# Changelog

All notable changes to this skill will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Added
-

### Changed
-

### Fixed
-

## [1.2.0] - 2025-12-02

### Added
- Pattern 5: Teaming Partner Discovery using `search_entities` tool for finding certified small businesses, competitors, and subcontractors by socioeconomic status, NAICS codes, and geography
- Pattern 6: Competitive Metrics Comparison using `get_vendor_metrics` tool for tracking competitor performance trends, assessing vendor health, and analyzing pipeline patterns over time
- Known Limitations: `search_entities` SAM registration dates return null (API data issue)
- Known Limitations: `search_entities` performance varies widely (300ms-9s depending on filter usage)
- Known Limitations: `get_vendor_metrics` CSV export broken (returns JSON despite csv parameter)

### Changed
- Refactored SKILL.md to use progressive disclosure: moved detailed Pattern 5 and Pattern 6 content to `references/query-patterns.md`

## [1.1.0] - 2025-12-02

### Added
- Quick reference table at top of SKILL.md with A6 UEI, CAGE code, primary contract vehicle, and competitor UEIs
- SPRUCE IDIQ contract vehicle details and complete holder list (all 10 vendors with UEIs)
- Contract vehicles section with SPRUCE expiration date (2029-09-30) and $2.44B ceiling
- Missing competitor UEIs: Coforma (CWKEYCF97KB6), CivicActions (XSZFHRS5QFL5), Ad Hoc (LJZ8SBUM9NM5)
- Known Limitations section documenting API constraints and workarounds
- Tool selection guide distinguishing search_contracts, search_opportunities, and search_forecasts
- Agency numeric codes for analytics queries (VA: 3600, HHS: 7500, GSA: 4700)
- HHS forecast availability notes (165+ forecasts available)
- Ad Hoc joint venture information (Peregrine Digital Services for SPRUCE access)

### Changed
- Corrected NAICS query format from string to array: `["541512", "541511", "541519"]`
- Updated all query patterns to use correct tool names (search_contracts vs search_opportunities)
- Fixed parameter names: `award_date_start` instead of `award_date_after` for contracts
- Clarified 541511 vs 541512 priority (541512 captures 65% of VA contracts despite 541511 being A6's registered primary)
- Replaced `search_tango_opportunities` with correct tool names throughout
- Updated Oddball competitive notes to reflect both companies now hold SPRUCE (equal vehicle access)
- Improved agency search documentation with full name requirements and abbreviation warnings
- Added `active: true` parameter to opportunity searches
- Changed ordering parameters to use correct field names (-posted_date, -obligated)

### Fixed
- Documented MCP server fixes validated: DQ-1 subawards API, MF-1 NAICS array filter, AD-3 cursor pagination, MF-3 agency lookup, MF-7 cache_timestamp
- Clarified set_aside field often null in results (filter works, display field unreliable)
- Documented VA forecast unavailability (VA does not publish forecasts to Tango)
- Added workarounds for missing obligated_min/max filters (use ordering + client-side filtering)
- Corrected pagination documentation: opportunities use page-based, contracts use cursor-based

## [1.0.0] - 2025-11-20

### Added
- Initial release of Agile Six market analyst skill
- Company profile with UEI, certifications, and contract performance data
- Strategic opportunity qualification framework (PURSUE/MONITOR/PASS)
- Optimized Tango MCP query patterns for VA opportunity discovery
- Competitor tracking guidance with UEIs and market segmentation
- VA market context and SDVOSB advantage analysis
- Reference files: competitors, agencies, market data, query patterns, tools
