---
name: a6-market-analyst
description: This skill should be used when conducting business development research for Agile Six Applications, Inc. using the Tango MCP server. It provides company profile, strategic guidance, and query optimization patterns for federal procurement data analysis focused on VA opportunities, SDVOSB set-asides, and competitive intelligence.
---

# Agile Six Market Analyst

## Quick Reference

| Item | Value |
|------|-------|
| **A6 UEI** | UP4JHKJQ9MQ7 |
| **CAGE Code** | 79H77 |
| **Primary Contract Vehicle** | SPRUCE IDIQ (36C10B25D0001) - $2.44B overall ceiling, expires 2029-09-30 |
| **Key Certification** | SDVOSB (12.8% VA market share) |
| **NAICS Search Order** | 541512 > 541511 > 541519 |
| **VA Agency Code** | 3600 |
| **Contract Size Sweet Spot** | $2M-$25M |

**Primary Competitor UEIs:**
- Oddball: MHNFNJ1J5RF5
- Coforma: CWKEYCF97KB6
- CivicActions: XSZFHRS5QFL5

## Overview

Use this skill when conducting business development research for Agile Six Applications, Inc. It combines company profile data, strategic pursuit criteria, and optimized Tango MCP query patterns to identify high-priority federal opportunities, track competitors, and analyze VA market dynamics.

**What This Skill Provides:**
- Company identifiers and certifications for query construction
- Strategic framework (PURSUE/MONITOR/PASS) for opportunity qualification
- Optimized query patterns for VA opportunity discovery
- Competitor tracking guidance
- Market positioning context

**Reference Files Available:**
- `references/competitors.md` - Detailed competitor profiles and tracking strategies
- `references/agencies.md` - Deep-dive on VA, HHS, GSA/TTS programs and initiatives
- `references/market-data.md` - Market statistics, contract data, quantitative analysis
- `references/query-patterns.md` - Advanced search strategies and multi-step workflows

## Company Profile

### Core Identifiers

| Field | Value |
|-------|-------|
| **UEI** | UP4JHKJQ9MQ7 |
| **Legal Name** | AGILE SIX APPLICATIONS, INC |
| **DBA Name** | AGILE SIX |
| **CAGE Code** | 79H77 |
| **Primary NAICS** | 541511 |
| **Founded** | November 2, 2014 |
| **Location** | 861 Harold Pl Ste 207, Chula Vista, CA 91914 |

### Contract Vehicles

| Vehicle | Contract Number | Ceiling | Award Date | Expiration |
|---------|-----------------|---------|------------|------------|
| **SPRUCE IDIQ** | 36C10B25D0001 | $2.44B | 2024-10-01 | 2029-09-30 |

**SPRUCE (Software Product Engineering, Research & User-Centered Experiences):** VA's primary vehicle for agile software development, user experience, and digital transformation services. A6 is one of only 10 holders, providing streamlined access to VA task orders. See `references/competitors.md` for the complete holder list.

### Key Certifications

| Certification | Code | Strategic Value |
|---------------|------|-----------------|
| **Service-Disabled Veteran Owned** | QF (SDVOSB) | **12.8% of VA software market** vs 1-2% government-wide |
| Veteran Owned Business | A5 (VOSB) | Secondary certification |
| Small Disadvantaged Business | 27 (SDB) | Additional set-aside access |

**Critical Advantage:** SDVOSB certification is 6-10x more valuable at VA than other agencies.

### NAICS Codes (Search Priority Order)

| NAICS Code | Description | Strategic Use |
|------------|-------------|---------------|
| **541512** | Computer Systems Design Services | **Lead with this - 65% of VA software contracts** |
| **541519** | Other Computer Related Services | Secondary - 30% of VA contracts |
| **541511** | Custom Computer Programming Services | A6's registered primary but only 5% of VA contracts |

**Important:** 541511 is A6's registered primary NAICS in SAM.gov, but 541512 should be prioritized in VA searches because it captures 65% of VA software contracts. Lead searches with 541512 for market coverage.

**Query Format:** Use `["541512", "541511", "541519"]` (array format) in priority order.

### Contract Performance

| Metric | All-Time | Active |
|--------|----------|--------|
| Total Contracts | 44 contracts | 16 contracts |
| **Total Obligated** | **$224,358,307** | **$80,393,138** |
| IDV Count | 8 IDVs | 5 IDVs |

**Customer Concentration:**
- VA: 90% of FY2024 awards (9 of 10 contracts)
- HHS: 10% of FY2024 awards (1 contract)
- **Risk:** Very high VA concentration - diversification critical

### Core Capabilities

**Verified Through Contract Awards:**
- VA.gov development and modernization
- Forms digitization (10-10EZ, 21-526EZ, CHAMPVA)
- Appointment and check-in systems
- Benefits processing applications
- Section 508 accessibility compliance (WCAG 2.1 AA)
- VA Design System implementation
- Agile/HCD methodologies
- Mobile application development (React Native)
- Cloud infrastructure (AWS GovCloud)

**NOT Our Capabilities:**
- Enterprise platform implementations (Salesforce, ServiceNow, AWS) as prime
- Large-scale infrastructure projects
- IT operations/endpoint management as core service
- Medical device manufacturing
- Physical security systems

## Strategic Guidance

### Target Agencies (Priority Order)

**Priority 1: Department of Veterans Affairs**
- 90% current revenue (stay focused here)
- SDVOSB advantage: 12.8% market share vs 1-2% government-wide
- Strong institutional knowledge and relationships
- See `references/agencies.md` for VA.gov, OCTO, VA Design System details

**Priority 2: Health and Human Services**
- Proven capability (Simpler Grants: $3.3M)
- Diversification opportunity
- Similar mission alignment (citizen services)
- See `references/agencies.md` for HHS programs and strategies

**Priority 3: GSA/TTS and USDS Agencies**
- Diversification targets
- Modern software practices alignment
- See `references/agencies.md` for specific opportunities

### Opportunity Qualification Framework

**PURSUE (High Priority - Bid These):**
- VA digital services (always consider)
- Veteran-facing applications/websites
- Form digitization or benefits processing
- Accessibility/508 compliance explicit requirement
- Agile/user-centered design methodology required
- SDVOSB set-aside (12.8% competitive advantage at VA)
- Contract size $2M-$25M (A6 capacity sweet spot)
- NAICS 541512 (65% of VA contracts) or 541511
- PSC codes: DA01, D302, R408

**MONITOR (Maybe/Teaming):**
- GSA modern software practices (diversification)
- HHS opportunities (proven capability with Simpler Grants)
- Enterprise platform deals $100M+ (subcontract for UX/design)
- Contract size >$25M (team or subcontract)
- Full & open competition (A6 wins these but harder)

**PASS (Low Priority/Outside Scope):**
- Construction/facilities (wrong NAICS)
- Medical equipment procurement
- Contract value <$500K (overhead not worth it)
- Waterfall methodology required (culture mismatch)
- Security clearance required (no facilities)
- Enterprise platform implementations as prime
- IT operations/endpoint management (not core capability)

### Contract Size Guidance

- **Minimum viable:** $500K (below this, overhead not worth it)
- **Ideal range:** $2M-$25M (capacity sweet spot)
- **Stretch maximum:** $50M (requires teaming/hiring)

**Note:** VA SDVOSB average is $215M but skewed by platform deals ($100M-$500M). A6 competes in custom development segment ($2M-$25M).

## Query Patterns

### Pattern 1: Daily VA Opportunity Discovery

Monitor new VA solicitations matching A6's profile.

```javascript
search_opportunities({
  agency: "Department of Veterans Affairs",
  naics_code: ["541512", "541511", "541519"],
  set_aside_type: "SDVOSB",
  posted_date_after: "YYYY-MM-DD",      // Last check date
  active: true,
  ordering: "-posted_date",
  limit: 50
})
```

**Then filter:** Check descriptions against PURSUE criteria, flag response deadlines, identify competitors.

**Note:** `search_opportunities` returns active solicitations from SAM.gov. For awarded contracts (competitive intelligence), use `search_contracts` instead.

**Warning:** VA does NOT publish forecasts to Tango. Use `search_opportunities` for active solicitations and `search_contracts` with expiration filters for recompete intelligence. Do not use `search_forecasts` for VA.

### Pattern 2: Recompete Pipeline Search

Identify expiring VA contracts for recompete opportunities.

```javascript
search_contracts({
  awarding_agency: "Department of Veterans Affairs",
  naics_code: ["541512", "541511", "541519"],
  expiration_date_after: "YYYY-MM-DD",   // +1 month from today
  expiration_date_before: "YYYY-MM-DD",  // +6 months from today
  ordering: "-obligated",
  limit: 50
})
```

**Analysis:** Contracts expiring in 1-6 months = potential recompetes. Check incumbent, scope alignment.

**Note:** Filter results client-side for $2M+ contracts (no `obligated_min` parameter exists). The `set_aside` field is often null in results.

### Pattern 3: Competitor Tracking (Oddball)

Track primary competitor Oddball's VA contract awards.

```javascript
search_contracts({
  vendor_uei: "MHNFNJ1J5RF5",  // Oddball UEI
  awarding_agency: "Department of Veterans Affairs",
  fiscal_year: 2025,
  ordering: "-award_date"
})
```

**Analysis:** Contract sizes, NAICS distribution, SPRUCE IDIQ usage, capability trends.

### Pattern 4: HHS Diversification

Find HHS opportunities aligned with A6's capabilities.

```javascript
search_opportunities({
  agency: "Department of Health and Human Services",
  naics_code: ["541512", "541511", "541519"],
  set_aside_type: "SDVOSB",
  posted_date_after: "YYYY-MM-DD",
  active: true,
  ordering: "-posted_date",
  limit: 50
})
```

**Focus:** Citizen-facing digital services, forms digitization, accessibility requirements.

**Note:** HHS has active forecasts available (165+ in software services NAICS codes). Use `search_forecasts` for pipeline planning.

### Pattern 5: Teaming Partner Discovery

Find certified small businesses for teaming and subcontracting. Essential for identifying partners with specific certifications (SDVOSB, 8A, WOSB) and geographic locations.

```javascript
search_entities({
  socioeconomic: "SDVOSB",
  naics_code: ["541512", "541511", "541519"],
  state: "VA",
  limit: 25
})
```

**For detailed workflows, performance optimization, and multi-step teaming strategies:** See `references/query-patterns.md` Pattern 5

### Pattern 6: Competitive Metrics Comparison

Track competitor performance over time and assess vendor health. Use quarterly grouping to compare growth trajectories or monthly to identify pipeline gaps.

```javascript
get_vendor_metrics({
  uei: "MHNFNJ1J5RF5",              // Competitor UEI (Oddball example)
  period_grouping: "quarter",
  months: 48
})
```

**For detailed analysis techniques, data interpretation, and red/green flags:** See `references/query-patterns.md` Pattern 6

**For more query patterns:** See `references/query-patterns.md` for 20+ advanced search strategies and multi-step workflows.

## Competitive Intelligence

### Direct Competitors (Same Segment)

Quick reference for tracking digital services SDVOSB competitors:

| Competitor | UEI | Threat Level | Key Advantage |
|------------|-----|--------------|---------------|
| **Oddball** | MHNFNJ1J5RF5 | Highest | Fellow SPRUCE holder, 10x scale ($426M) |
| **Coforma** | CWKEYCF97KB6 | High | SDVOSB + 8(a) dual cert, SPRUCE + OASIS+ holder |
| **CivicActions** | XSZFHRS5QFL5 | Medium | 20+ year track record, open source focus |
| **Ad Hoc** | LJZ8SBUM9NM5 | Medium | Strong VA.gov credentials, 400+ staff |

**Market Segmentation:**
- A6 competes in **custom development** (30-40% of VA software market)
- Platform leaders (V3Gate, Four Points, MetGreen) operate in $100M-$500M deals (different segment)
- Track platform leaders for **subcontracting opportunities**, not prime competition

**For detailed competitor profiles, tracking strategies, and market segmentation analysis:** See `references/competitors.md`

## Market Context

### VA SDVOSB Market

**Market Size:**
- Total VA software contracts (NAICS 541511/541512/541519): 7,986 contracts
- SDVOSB contracts: 1,026 contracts (12.8% market share)
- Full & Open: ~87% of market

**SDVOSB Advantage Quantified:**
- Government-wide SDVOSB: 1-2% of market
- VA-specific SDVOSB: **12.8% of market**
- **6-10x higher** at VA than other agencies

**Validation:** SDVOSB certification is significantly more valuable at VA due to strong institutional preference.

### Common PSC Codes

| PSC Code | Description | A6 Strategic Fit |
|----------|-------------|------------------|
| **DA01** | IT - App Development Support (Labor) | **Core A6 work** - HCD, DevSecOps, UX |
| **D302** | IT - Systems Development | Systems development & integration |
| **R408** | Program Management/Support Services | Program management support |

**For detailed market statistics, NAICS distribution, contract size analysis, and quantitative data:** See `references/market-data.md`

## Key VA Programs

**VA.gov Digital Transformation:**
- 17M monthly users, 1.3M mobile app users
- #1 federal IT customer satisfaction (5 consecutive years)
- Major initiatives: GI Bill, PACT Act, forms digitization, cloud migration
- Official hub: digital.va.gov

**OCTO (Office of the Chief Technology Officer):**
- CTO: Charles Worthington (since 2017)
- Focus: Agile development, accessibility, AI governance
- Perfect alignment with A6's capabilities

**VA Design System (VADS):**
- Website: design.va.gov
- React-based component library
- A6 has implementation expertise
- Ongoing evolution = opportunity pipeline

**For detailed program information, contracting offices, and opportunity signals:** See `references/agencies.md`

## Red Flags: Wired Solicitations

**Warning Signs to Surface:**
- Incumbent on 5+ year contract with recent modifications (likely satisfied customer)
- Posted Friday before 3-day weekend with 10-day response (wired for incumbent)
- Proprietary tool requirements matching incumbent's stack
- Evaluation criteria heavily weighted to "number of staff" (favors large firms)

**Strategy:** Don't waste resources on wired deals unless strategic.

## Using This Skill

### Typical Workflows

**Daily Opportunity Monitoring:**
1. Run Pattern 1 (VA Opportunity Discovery)
2. Filter by contract size ($2M-$25M)
3. Apply PURSUE/MONITOR/PASS criteria
4. Flag high-priority opportunities

**Competitive Intelligence:**
1. Run Pattern 3 (Oddball Tracking)
2. Repeat for other competitors (see `references/competitors.md` for UEIs)
3. Analyze trends: contract sizes, capabilities, set-aside usage
4. Identify competitive gaps and advantages

**Recompete Pipeline Development:**
1. Run Pattern 2 (Recompete Pipeline Search)
2. Analyze incumbent performance and satisfaction
3. Assess scope alignment with A6 capabilities
4. Monitor for RFP publication

**Market Research:**
1. Consult `references/market-data.md` for quantitative analysis
2. Use `references/agencies.md` for program-specific intelligence
3. Apply `references/query-patterns.md` for advanced multi-step workflows

### When to Consult Reference Files

**Use `references/competitors.md` when:**
- Conducting competitive intelligence
- Planning competitive strategy
- Identifying teaming/subcontracting targets
- Analyzing market segmentation

**Use `references/agencies.md` when:**
- Researching specific VA programs (OCTO, VA Design System)
- Developing HHS diversification strategy
- Understanding agency buying patterns
- Mapping contracting offices

**Use `references/market-data.md` when:**
- Analyzing market trends and statistics
- Sizing opportunity pipeline
- Understanding NAICS/PSC distribution
- Validating strategic assumptions

**Use `references/query-patterns.md` when:**
- Building complex multi-step research workflows
- Optimizing query performance
- Conducting cross-agency analysis
- Creating tracking dashboards

## Known Limitations

**API and Data Constraints:**

| Limitation | Workaround |
|------------|------------|
| Agency abbreviations don't work in `search_contracts` | Use full name ("Department of Veterans Affairs") or numeric code ("3600"). Use `lookup_agency` to find correct identifiers. |
| VA has no forecasts in Tango | Use `search_opportunities` for active solicitations; use `search_contracts` with expiration filters for recompete intelligence |
| `set_aside` field often null in contract results | The `set_aside_type` filter works correctly (returns matching contracts), but the `set_aside` field in results is often null. Trust the filter; don't rely on the field value for display. |
| No `obligated_min/max` filters | Sort by value with `ordering: "-obligated"` (largest first) or `"obligated"` (smallest first), then filter client-side. Use `shape` parameter to minimize payload when over-fetching. |
| NAICS filtering unreliable for opportunities | SAM.gov tagging is sparse; broaden searches and filter by description keywords |
| Set-aside codes have variants | API accepts "SDVOSB" and matches both "SDVOSB" and "SDVOSBC" (competitive). Results may show "SDVOSBC" for "Service-Disabled Veteran-Owned Small Business Set Aside - Competitive" |
| `search_entities` SAM registration dates null | `registration_status` and `sam_activation_date`/`sam_expiration_date` return null (API data issue). Cannot filter by active registration status. |
| `search_entities` performance varies widely | Execution times: 300-400ms for filtered/cached queries, up to 9s for large unfiltered searches (64K+ SDVOSBs). Always use filters (state, NAICS) for better performance. |
| `get_vendor_metrics` CSV export broken | `export_format: "csv"` parameter accepted but returns JSON format (API bug). Use JSON format only. |

**Remember:** This SKILL.md provides essential information. Reference files contain detailed data - use them for deep dives and comprehensive analysis.
