# Agency-Specific Intelligence

This file contains detailed information about target agencies and their programs. For strategic prioritization, see the main SKILL.md.

## Priority 1: Department of Veterans Affairs

### Current Relationship

**Revenue Concentration:**
- 90% of FY2024 contract awards (9 of 10 contracts)
- $224M total VA obligations (all-time)
- $80M in active VA obligations

**Primary Contracting Office:**
- VA Technology Acquisition Center NJ (36C10B)
- Strong established relationship
- Repeat awards demonstrate trust

**Risk Assessment:**
- Very high customer concentration
- Single point of failure risk
- Diversification imperative

### VA.gov Digital Transformation

**Program Overview:**
- **Status:** Active, multi-year initiative
- **Official Hub:** digital.va.gov
- **Scale:**
  - 17M monthly users on VA.gov
  - 1.3M users on VA mobile app
  - 99.9% uptime on 100 critical systems

**Performance Recognition:**
- #1 in federal IT customer satisfaction (5 consecutive years)
- Industry-leading uptime and reliability

**Major Initiatives:**
- GI Bill modernization
- PACT Act implementation (toxic exposure benefits)
- Cloud migration (AWS GovCloud)
- AI integration and governance
- Forms digitization pipeline

**A6's Role:**
- Appointment and check-in experience ($22.7M)
- Sitewide product team support ($4.7M)
- Forms digitization (10-10EZ, 21-526EZ, CHAMPVA)
- Health enrollment systems ($5.0M)
- Toxic exposure processing ($5.0M)

**Future Opportunities:**
- Continued forms digitization (many paper forms remain)
- Mobile app enhancements
- AI-powered veteran services
- Accessibility improvements
- Design system evolution

### OCTO (Office of the Chief Technology Officer)

**Organizational Status:**
- Real VA office within Office of Information Technology (OIT)
- Not a temporary initiative - permanent structure

**Leadership:**
- **CTO:** Charles Worthington (since 2017)
- **Also serves as:** Chief Artificial Intelligence Officer (CAIO)
- Long tenure indicates stability and vision

**Mission:**
- Partners with VA health care and service providers
- Focuses on understanding veteran needs
- Drives technology modernization from user perspective

**Focus Areas:**
- Agile development methodologies
- Accessibility and inclusive design
- AI governance and implementation
- User-centered technology solutions

**Notable Achievements:**
- Increased assistive technology participant database by 20x (2022)
- VA.gov 5-year customer satisfaction leadership
- Cloud migration execution

**Implications for A6:**
- OCTO's priorities align perfectly with A6's capabilities
- Accessibility focus = A6 competitive advantage
- Agile/HCD alignment = cultural fit
- Charles Worthington's long tenure = consistent buyer

### VA Design System (VADS)

**System Overview:**
- **Official Website:** design.va.gov
- **Status:** Comprehensive system, actively maintained
- **Purpose:** Guidelines and code for trustworthy, accessible, consistent digital services

**Components:**
- **Content Style Guide:** Writing and content guidelines for VA.gov
- **Foundation:** Base styles, design tokens, accessibility standards
- **UI Components:** Reusable React components
- **Patterns:** Common UX patterns for VA services
- **Figma Libraries:** Design prototyping tools

**Technical Details:**
- **Repository:** GitHub (department-of-veterans-affairs/vets-design-system-documentation)
- **License:** Open source (available for government and public use)
- **Technology:** React-based components
- **Standards:** WCAG 2.1 AA accessibility compliance

**A6's Expertise:**
- Design system implementation experience
- Authenticated experience patterns
- Accessibility compliance (Section 508)
- Component development and customization

**Future Opportunities:**
- Design system evolution and maintenance
- New component development
- Pattern library expansion
- Accessibility testing and validation
- Mobile design system extensions

### VA Contract Landscape

**Market Size (2024-2025):**
- Total contracts in NAICS 541511/541512/541519: **7,986 contracts**
- SDVOSB contracts: **1,026 contracts (12.8%)**
- Full & Open: ~87% of market

**Top Contractors Overall:**
1. Dell Federal Systems - $1.73B
2. Oracle Health Gov Services - $1.28B
3. Liberty IT Solutions - $1.14B
4. Booz Allen Hamilton - $1.10B
5. CGI Federal - $775M

**First SDVOSB:** V3Gate ($576M) at rank 11

**Market Segmentation:**
- Enterprise platforms: 40-50% (Salesforce, ServiceNow, AWS)
- Custom development: 30-40% (A6's segment)
- IT operations: 20-30% (endpoint management, help desk)

### VA SDVOSB Advantage

**Government-Wide SDVOSB:**
- 271K+ contracts
- 1-2% of total federal market

**VA-Specific SDVOSB:**
- 1,026 contracts
- **12.8% of VA software market**
- **6-10x higher** than government-wide average

**Validation:**
- SDVOSB certification significantly more valuable at VA
- Strong institutional preference for veteran-owned businesses
- Set-aside usage growing in IT contracts

**Implication:**
- VA should remain primary focus
- SDVOSB advantage is quantified and sustainable
- Diversification doesn't mean abandoning VA

### Target Contract Vehicles

**SPRUCE (VA-Specific):**
- **Status:** VA's premier digital services IDIQ
- **Current Holder:** Oddball (competitive disadvantage)
- **Strategy:** Pursue recompete or new VA vehicles
- **Value:** Streamlined access to VA task orders

**VA Contracting Offices:**
- VA Technology Acquisition Center NJ (36C10B) - A6's primary office
- Other VA TACs to explore for diversification

### Opportunity Signals at VA

**High-Priority Signals:**
- VA.gov keyword in solicitation
- Forms digitization scope
- Accessibility/508 compliance required
- Agile/iterative methodology
- SDVOSB set-aside
- NAICS 541512 or 541511
- $2M-$25M contract size
- PSC codes: DA01, D302, R408

**Watch Signals:**
- Mobile app development
- Design system work
- API development
- Benefits processing
- Health enrollment systems

**Pass Signals:**
- Enterprise platform implementations
- IT operations/help desk
- Security clearance required
- Waterfall methodology
- <$500K contract size

## Priority 2: Department of Health and Human Services

### Current Relationship

**Proven Capability:**
- Simpler Grants project: $3.3M
- Demonstrates ability to win and deliver outside VA
- Similar mission alignment (citizen services)

**Revenue Share:**
- ~10% of FY2024 awards
- Diversification started but needs expansion

### Strategic Rationale

**Mission Alignment:**
- Citizen-facing digital services (like VA.gov)
- Forms digitization needs (like VA benefits)
- Healthcare focus (adjacent to VA healthcare)
- Accessibility requirements (same as VA)

**Technical Alignment:**
- Healthcare.gov modernization (Oddball, Ad Hoc, CivicActions compete here)
- Agile/HCD methodologies
- Mobile applications
- User research and testing

**Market Opportunity:**
- Large agency with digital services needs
- SDVOSB set-asides available (though less than VA)
- Lower incumbent advantage than VA

### Target Programs

**Healthcare.gov:**
- Major digital platform (similar scale to VA.gov)
- Ongoing modernization needs
- Competitors: Oddball, Ad Hoc, CivicActions (A6 can compete)

**Grants Modernization:**
- Simpler Grants project (A6 current contract)
- Broader grants.gov modernization
- Forms digitization opportunity

**Medicare/Medicaid Digital Services:**
- Beneficiary-facing applications
- Similar to VA benefits processing
- Mobile app opportunities

**FDA Digital Initiatives:**
- Public-facing regulatory systems
- Form submission modernization
- Potential SDVOSB set-asides

### HHS Contracting Landscape

**SDVOSB Opportunities:**
- Less concentrated than VA (no 12.8% preference)
- Still government-wide 3% SDVOSB goal applies
- Competition includes same firms (Oddball, Coforma, Ad Hoc)

**Contract Vehicles:**
- OASIS+ (Coforma has this - A6 should pursue)
- GSA MAS (multiple award schedule)
- Agency-specific IDIQs

### Diversification Strategy

**Current State:** 10% HHS, 90% VA

**Target State:** 20-30% HHS, 60-70% VA, 10% other

**Approach:**
- Build on Simpler Grants success
- Target similar citizen-facing work
- Leverage accessibility expertise
- Apply VA.gov lessons learned
- Pursue healthcare.gov opportunities

## Priority 3: GSA/TTS and USDS Agencies

### General Services Administration (GSA)

**Technology Transformation Services (TTS):**
- **Mission:** Help agencies build, buy, and share technology
- **Programs:** Login.gov, Cloud.gov, Digital Analytics Program, U.S. Web Design System

**Alignment with A6:**
- Modern software practices
- Agile/HCD culture
- Open source focus
- Accessibility standards
- Design system expertise (similar to VA Design System)

**Opportunity Areas:**
- Login.gov development and expansion
- U.S. Web Design System evolution (similar to VADS work)
- Digital service consulting
- Cloud.gov enhancements

**Contract Vehicles:**
- GSA MAS (Multiple Award Schedule) - A6 should have/pursue
- 18F acquisitions
- TTS-wide contracts

### U.S. Digital Service (USDS) Partner Agencies

**USDS Mission:**
- Deploy teams to federal agencies
- Drive digital transformation
- Fix critical services

**Partner Agencies (Diversification Targets):**
- Department of Education
- Small Business Administration
- Immigration services (USCIS)
- Social Security Administration
- Department of Labor

**USDS Cultural Alignment:**
- Same Agile/HCD principles as A6
- User-centered design
- Modern tech stacks
- Accessibility focus
- Iterative development

**Opportunity Strategy:**
- Target agencies with USDS engagement
- Alignment signals modern practices required
- Less entrenched incumbents than VA
- SDVOSB still provides advantage

### Contract Vehicle Strategy

**Current A6 Vehicles:**
- 8 total IDIQ/BPA vehicles (5 active)
- Provides rapid response capability

**Target Vehicles for Diversification:**
- **GSA MAS** (Multiple Award Schedule) - broad federal access
- **OASIS+** (like Coforma has) - 15-year GWAC
- **NASA SEWP** (like Ad Hoc has) - IT products and services
- Agency-specific IDIQs at HHS, GSA

**Vehicle Benefits:**
- Streamlined procurement
- Pre-qualified vendor status
- Easier task order competitions
- Reduced proposal overhead

## Cross-Agency Opportunities

### Accessibility/508 Compliance Market

**Market Need:**
- All agencies required to comply
- Many legacy systems non-compliant
- Retrofitting existing applications

**A6 Competitive Advantage:**
- Verified expertise through VA work
- WCAG 2.1 AA experience
- Assistive technology testing
- Section 508 compliance validation

**Target Agencies:**
- Any agency with public-facing systems
- Education, Labor, SBA (citizen services)
- Healthcare agencies (HHS, VA synergy)

### Forms Digitization Market

**Market Need:**
- Government-wide push to digitize paper forms
- 21st Century IDEA Act requirements
- User experience improvements

**A6 Competitive Advantage:**
- VA forms expertise (10-10EZ, 21-526EZ, CHAMPVA)
- Form builder experience
- Accessibility in forms
- Mobile-responsive forms

**Target Agencies:**
- HHS (grants, Medicare applications)
- Education (student aid forms)
- SBA (business registration)
- Labor (unemployment systems)

### Mobile Application Development

**Market Need:**
- Citizen preference for mobile access
- Government mobile-first mandates
- App modernization

**A6 Competitive Advantage:**
- VA mobile app experience (1.3M users)
- React Native expertise
- Mobile accessibility
- Authenticated mobile experiences

**Target Agencies:**
- Any agency serving citizens directly
- Healthcare (HHS/VA)
- Benefits administration (SSA, Labor)
- Education services

## Geographic Considerations

**A6 Locations:**
- Headquarters: Chula Vista, CA
- Remote workforce capability

**VA Contracting:**
- Primary: VA TAC NJ (36C10B)
- Relationship established
- Remote delivery accepted

**Expansion Opportunities:**
- HHS: Washington, DC area contracting
- GSA: DC and regional offices
- Consider DC area presence for relationship building

**On-Site Requirements:**
- Flag as PASS criteria if no A6 presence
- Remote/hybrid increasingly accepted post-COVID
- Some agencies still require on-site

## Agency Research Queries

**Important:** `lookup_agency` accepts abbreviations (VA, DOD, HHS), but `search_contracts` does NOT. Always use full agency names or numeric codes when searching contracts.

### Find VA Active Solicitations

```javascript
search_opportunities({
  agency: "Department of Veterans Affairs",
  naics_code: ["541512", "541511", "541519"],
  set_aside_type: "SDVOSB",
  posted_date_after: "YYYY-MM-DD",
  active: true,
  ordering: "-posted_date",
  limit: 50
})
```

**Note:** VA does NOT publish forecasts to Tango. Use `search_opportunities` for pipeline visibility.

### Find VA Contract Awards (Competitive Intelligence)

```javascript
search_contracts({
  awarding_agency: "Department of Veterans Affairs",
  naics_code: ["541512", "541511", "541519"],
  set_aside_type: "SDVOSB",
  award_date_start: "YYYY-MM-DD",
  ordering: "-obligated",
  limit: 50
})
```

### Find HHS Diversification Opportunities

**Active Solicitations:**
```javascript
search_opportunities({
  agency: "Department of Health and Human Services",
  naics_code: ["541512", "541511", "541519"],
  set_aside_type: "SDVOSB",
  posted_date_after: "YYYY-MM-DD",
  active: true,
  ordering: "-posted_date",
  limit: 50
})
```

**HHS Forecasts (Pipeline Planning):**
```javascript
search_forecasts({
  agency: "HHS",
  naics_code: ["541512", "541511", "541519"],
  fiscal_year: 2025,
  status: "PUBLISHED",
  limit: 50
})
```

**Note:** HHS has 179 forecasts available (as of Dec 2024).

### Find GSA/TTS Contract Awards

```javascript
search_contracts({
  awarding_agency: "General Services Administration",
  naics_code: ["541512", "541511", "541519"],
  award_date_start: "YYYY-MM-DD",
  ordering: "-obligated",
  limit: 50
})
```

### Cross-Agency Accessibility Work

```javascript
search_opportunities({
  naics_code: ["541512", "541511", "541519"],
  set_aside_type: "SDVOSB",
  query: "accessibility",
  posted_date_after: "YYYY-MM-DD",
  active: true,
  ordering: "-posted_date",
  limit: 50
})
```

### Agency Analytics (Requires Numeric Code)

```javascript
get_agency_analytics({
  agency_code: "3600",  // VA - MUST be numeric
  fiscal_year: 2024,
  include_trends: true
})
```

**Agency Codes:**
- VA: `3600`
- HHS: `7500`
- GSA: `4700`
- DOD: `9700`
- Education: `9100`
