# Competitive Intelligence Reference

This file contains detailed competitor profiles for tracking and analysis. For strategic guidance on market segmentation, see the main SKILL.md.

## SPRUCE IDIQ Competitive Landscape

The SPRUCE (Software Product Engineering, Research & User-Centered Experiences) IDIQ is VA's primary vehicle for agile software development and digital transformation. Only 10 vendors hold positions, making this a critical competitive battleground.

**Contract Details:**
- Award Date: 2024-10-01
- Expiration: 2029-09-30
- Ceiling: $2.44B (overall vehicle ceiling, shared across all holders)
- Type: Multiple Award IDIQ

### Complete SPRUCE Holder List

| Vendor | UEI | Notes |
|--------|-----|-------|
| **Agile Six** | UP4JHKJQ9MQ7 | A6's primary VA access vehicle |
| **Oddball** | MHNFNJ1J5RF5 | Primary competitor, 10x scale |
| **Coforma** | CWKEYCF97KB6 | SDVOSB + 8(a) dual certification |
| **Rise8** | FZG5H96FF1V4 | Newer entrant, DoD background |
| **Magnum Opus** | E4LVKBFDBTD9 | |
| **Aquia Nava II** | WFCXH3WKD4K7 | Nava spinout/partnership |
| **Peregrine Digital** | Y9HWG178WPA9 | Ad Hoc + IronArch JV |
| **AVB Digital II** | RHFJYYSNG1U4 | |
| **One Phoenix** | XFS1D6ZB5FC5 | |
| **Bravo Communications** | C2P7M1SK6VM3 | |

**Tracking Strategy:** Monitor SPRUCE task order awards using:
```javascript
search_contracts({
  vendor_uei: "[UEI]",  // Any holder UEI from above
  awarding_agency: "Department of Veterans Affairs",
  fiscal_year: 2025,
  ordering: "-award_date"
})
```

## Direct Competitors (Digital Services SDVOSB)

### Tier 1: Oddball (Primary Threat)

**Company Profile:**
- **UEI:** MHNFNJ1J5RF5
- **Status:** SDVOSB certified
- **Website:** oddball.io
- **Scale:** $426M contract volume (10x Agile Six)

**Major Contracts:**
- VA.gov VSP (Veteran-facing Services Platform): $78M (3-year)
- CMS MAX: $15M
- OPM Modernization: $7M

**Key Competitive Advantages:**
- SPRUCE IDIQ holder (both A6 and Oddball hold SPRUCE - equal footing on vehicle access)
- 10x scale vs Agile Six ($426M vs A6's ~$224M)
- Same capabilities segment

**Technical Capabilities:**
- Full-stack development
- Human-centered design (HCD)
- DevOps and CI/CD pipelines
- Cloud migration
- UX design

**Platforms/Customers:**
- Healthcare.gov
- VA.gov
- MyMedicare.gov
- OPM.gov

**Competitive Threat Level:** **HIGHEST**
- Same segment (digital services SDVOSB)
- Same capabilities (custom development, HCD, accessibility)
- Both hold SPRUCE (no vehicle advantage either way)
- 10x scale provides more capacity for larger task orders

**Tracking Strategy:**
- Monitor VA awards to UEI MHNFNJ1J5RF5
- Track SPRUCE IDIQ usage
- Analyze contract size trends
- Watch for capability expansion
- Note set-aside usage patterns

### Tier 2: Coforma

**Company Profile:**
- **UEI:** CWKEYCF97KB6
- **Status:** SDVOSB + 8(a) certified (dual certification advantage)
- **Founded:** 2017
- **Location:** Rockville, MD
- **Website:** coforma.io

**Contract Vehicles:**
- OASIS+ (15-year GWAC - major advantage)

**Focus Areas:**
- Human-centered design
- Digital transformation
- Minority-owned business focus

**Service Areas:**
- Healthcare
- Immigration
- Veterans services
- Voting systems
- Access to justice

**Competitive Threat Level:** **HIGH**
- Similar capabilities to A6
- Dual certification (SDVOSB + 8(a)) provides more set-aside access
- OASIS+ vehicle provides broad federal access
- Founded same era as A6 (2017 vs 2014)

**Tracking Strategy:**
- Monitor dual set-aside opportunities (SDVOSB + 8(a))
- Track OASIS+ task order awards
- Watch for VA penetration
- Note HHS/healthcare work (overlap with A6 diversification)

### Tier 3: CivicActions

**Company Profile:**
- **UEI:** XSZFHRS5QFL5
- **Status:** Small Business (NOT SDVOSB - key differentiator)
- **Founded:** 2004 (20+ year track record)
- **Website:** civicactions.com

**Major Contracts:**
- CMS WECMS: $18.25M (2020)
- Healthcare.gov management

**Specialization:**
- FOSS (Free and Open Source Software) solutions
- Open source community leadership

**Agencies Served:**
- Department of Veterans Affairs
- FCC (Federal Communications Commission)
- Department of Education
- Department of Justice
- Department of Treasury
- Department of Health and Human Services

**Differentiator:**
- Open source focus (unique positioning)
- 20+ years established (vs A6's 10 years)
- Broader agency diversification

**Competitive Threat Level:** **MEDIUM**
- Lacks SDVOSB advantage (major disadvantage at VA)
- Longer track record provides credibility
- Open source positioning may appeal to certain buyers
- Broader agency portfolio than A6

**Tracking Strategy:**
- Monitor full & open VA competitions (where they compete head-to-head)
- Track open source/FOSS requirements in RFPs
- Note agency diversification patterns
- Watch for small business set-aside wins

### Tier 4: Ad Hoc

**Company Profile:**
- **UEI:** LJZ8SBUM9NM5
- **Status:** Established digital services firm (10+ years)
- **Website:** adhoc.team / adhocteam.us
- **Scale:** 400+ federal contractor jobs

**Note:** The `get_company_intelligence` tool may return wrong company (e.g., "AD HOC ANALYTICS, LLC") due to imprecise name matching. Use UEI `LJZ8SBUM9NM5` for precise tracking, or search via `vendor_name: "Ad Hoc LLC"` in `search_contracts`.

**Joint Venture:** Ad Hoc formed "Peregrine Digital Services" (UEI: Y9HWG178WPA9) with IronArch Technology, which holds a SPRUCE IDIQ position. This gives Ad Hoc indirect access to SPRUCE task orders.

**Notable Achievements:**
- Rebuilt HealthCare.gov (high-profile rescue)
- Built Vets.gov (predecessor to VA.gov)
- Rebuilt VA.gov
- Medicare Plan Finder (2.6M beneficiaries, 40% enrollment increase)

**Contract Vehicles:**
- GSA MAS (Multiple Award Schedule)
- OASIS+
- NASA SEWP V

**Differentiator:**
- High-profile government digital rescue projects
- Strong VA.gov credentials and institutional knowledge
- Large team capacity (400+ contractors)

**Competitive Threat Level:** **MEDIUM**
- Lacks SDVOSB certification (major disadvantage at VA)
- Strong VA.gov track record creates incumbent advantage on related work
- Large scale (400+ vs A6's smaller team)
- High-profile rescue projects build credibility

**Tracking Strategy:**
- Monitor VA.gov related RFPs (institutional knowledge advantage)
- Track full & open competitions at VA
- Watch for teaming arrangements
- Note healthcare.gov and Medicare work

## VA SDVOSB Platform Leaders (Different Segment)

**Market Context:** These competitors operate in enterprise platform deals ($100M-$500M scale). They are NOT direct competitors for custom development work but represent subcontracting opportunities.

### Enterprise Platform Specialists

#### V3Gate
- **Top Contract Value:** $576M
- **Specialization:** Salesforce ELA, platform integration
- **Market Position:** 3 contracts in VA top 10
- **Opportunity:** Subcontract for UX/design on Salesforce implementations

#### Four Points Technology
- **Top Contract Value:** $406M
- **Specialization:** AWS Cloud services, cloud migration leader
- **Opportunity:** Subcontract for application development on AWS migrations

#### MetGreen Solutions
- **Top Contract Value:** $312M
- **Specialization:** ServiceNow SaaS, enterprise implementations
- **Opportunity:** Subcontract for custom integrations and UX

#### Liberty IT Solutions
- **Top Contract Value:** $320M
- **Specialization:** Health integration systems
- **Opportunity:** Subcontract for veteran-facing interfaces

#### Halfaker and Associates
- **Top Contract Value:** $195M
- **Specialization:** T4NG (Transformation Twenty-One Total Technology Next Generation) transformation programs
- **Opportunity:** Subcontract for agile development components

#### GovCIO
- **Top Contract Value:** $194M
- **Specialization:** Technology incubation, T4NG participant
- **Opportunity:** Subcontract for innovation/prototyping work

### Operations & Support (Not Direct Competition)

These vendors focus on IT operations, not software development:

- **IT Concepts:** $237M (Endpoint support)
- **Minburn Technology Group:** $229M (Endpoint management)
- **Quantum Management:** $190M (Engineering/governance)

**Strategic Note:** Monitor for teaming opportunities but not direct competition.

## Market Segmentation Analysis

### A6's Market Segment: Custom Development & Integration (30-40% of VA software market)

**Where A6 Competes:**
- Forms digitization
- VA.gov development
- Design system implementation
- Accessibility compliance
- API development
- Human-centered design
- Agile software development
- Typical contract size: $2M-$25M

**Direct Competitors in This Segment:**
1. Oddball (highest threat - SPRUCE + scale)
2. Coforma (high threat - dual certification + OASIS+)
3. CivicActions (medium threat - longer track record)
4. Ad Hoc (medium threat - VA.gov credentials)

### Enterprise Platform Segment (40-50% of VA software market)

**NOT A6's Segment (Subcontracting Only):**
- Salesforce implementations
- ServiceNow deployments
- AWS cloud migrations
- Large-scale platform integrations
- Typical contract size: $100M-$500M

**Platform Leaders (Subcontracting Targets):**
- V3Gate, Four Points Technology, MetGreen Solutions, Liberty IT Solutions

### IT Operations & Support (20-30% of VA software market)

**NOT A6's Segment:**
- Endpoint management
- Help desk operations
- IT infrastructure support
- Security operations centers

**Operations Leaders (Not Relevant):**
- IT Concepts, Minburn Technology Group, Quantum Management

## Competitive Tracking Queries

### Track Oddball (Primary Competitor)

```javascript
search_contracts({
  vendor_uei: "MHNFNJ1J5RF5",  // Oddball UEI
  awarding_agency: "Department of Veterans Affairs",
  fiscal_year: 2025,
  ordering: "-award_date"
})
```

**Analysis Focus:**
- Contract size trends (are they moving up/down market?)
- NAICS code distribution (capability expansion?)
- Set-aside usage patterns (SDVOSB vs full & open)
- SPRUCE IDIQ usage frequency
- New capability areas

**Other Competitor UEIs:**
- Coforma: `CWKEYCF97KB6`
- CivicActions: `XSZFHRS5QFL5`
- Ad Hoc: `LJZ8SBUM9NM5`

### Monitor All SDVOSB Digital Services Awards

```javascript
search_contracts({
  awarding_agency: "Department of Veterans Affairs",
  naics_code: ["541512", "541511", "541519"],
  set_aside_type: "SDVOSB",
  award_date_start: "YYYY-MM-DD",
  ordering: "-obligated",
  limit: 100
})
```

**Analysis Focus:**
- Who's winning (competitor market share trends)
- Contract descriptions (capability trends)
- Contract sizes (market segment shifts) - filter client-side for $2M+
- Geographic distribution
- New entrants to watch

**Note:** Use `export_format: "csv"` for spreadsheet analysis.

### Identify Subcontracting Opportunities

```javascript
search_contracts({
  awarding_agency: "Department of Veterans Affairs",
  naics_code: ["541512"],
  award_date_start: "YYYY-MM-DD",
  ordering: "-obligated",
  limit: 50
})
```

**Strategy:** Filter client-side for $100M+ contracts, then identify platform vendors.

**Analysis Focus:**
- Platform vendors winning large deals
- Opportunity for UX/design subcontracts
- Relationship building targets

## Red Flags: Wired Solicitations

**Warning Signs to Surface:**

1. **Incumbent Satisfaction Signals:**
   - Incumbent on 5+ year contract with recent modifications (likely satisfied customer)
   - Multiple option year exercises without gaps
   - Recent scope expansions via modifications

2. **Procurement Manipulation:**
   - Posted Friday before 3-day weekend with 10-day response deadline
   - Proprietary tool requirements matching incumbent's stack
   - Evaluation criteria heavily weighted to "number of staff" (favors large firms)

3. **Recompete Formalities:**
   - Posted with >30 days for proposals BUT incumbent just got major modification
   - Unusual technical requirements matching incumbent's specific approach
   - Past performance requirements that perfectly match incumbent's portfolio

4. **Oddball-Specific Signals:**
   - SPRUCE IDIQ task order (Oddball has inside track)
   - Requirements mentioning "VSP" (Veteran-facing Services Platform - Oddball contract)
   - Continuation of existing VA.gov VSP work

**Strategy:** Don't waste resources on wired deals unless strategic relationship building justifies the effort.
