# Market Data Reference

This file contains detailed market statistics, contract data, and quantitative analysis. For strategic interpretation, see the main SKILL.md.

**Data Currency:** Statistics in this document are based on data retrieved December 2024. Recommend monthly refresh of market data queries.

## VA Software Contract Market Overview

### Market Size (Data as of December 2024)

**Total Contracts:**
- NAICS 541511/541512/541519: **7,986 contracts**
- SDVOSB contracts: **1,026 contracts**
- SDVOSB market share: **12.8%**
- Full & Open competition: ~87% of market

**Key Finding:** VA has significantly higher SDVOSB penetration than government-wide average.

### Top Contractors (Data as of December 2024)

**Overall VA IT Ranking:**
1. **Dell Federal Systems** - $1.73B
2. **Oracle Health Gov Services** - $1.28B
3. **Liberty IT Solutions** - $1.14B
4. **Booz Allen Hamilton** - $1.10B
5. **CGI Federal** - $775M

**First SDVOSB Appearance:** V3Gate at rank 11 ($576M)

**Top 10 SDVOSB Contractors at VA:**

| Rank | Vendor | Top Contract Value | Specialization |
|------|--------|-------------------|----------------|
| 1 | **V3Gate** | $576M | Salesforce ELA, platform integration |
| 2 | **Oddball** | $426M | Digital services, VA.gov development |
| 3 | **Four Points Technology** | $406M | AWS Cloud services |
| 4 | **Liberty IT Solutions** | $320M | Health integration systems |
| 5 | **MetGreen Solutions** | $312M | ServiceNow SaaS |
| 6 | **IT Concepts** | $237M | Endpoint support |
| 7 | **Minburn Technology Group** | $229M | Endpoint management |
| 8 | **Agile Six** | $224M | Custom development, VA.gov |
| 9 | **Halfaker and Associates** | $195M | T4NG transformation |
| 10 | **GovCIO** | $194M | Technology incubation |

**A6 Position:** Rank 8 among SDVOSB contractors ($224M total obligations)

**Market Segmentation:**
- Platform leaders (V3Gate, Four Points, MetGreen): $100M-$500M deals
- Digital services (Oddball, A6): $2M-$25M deals
- Operations (IT Concepts, Minburn): Support contracts

## SDVOSB Advantage Quantification

### Government-Wide SDVOSB Market

**Total SDVOSB Contracts:** 271K+ contracts across all agencies

**Market Share:** 1-2% of total federal contract market

**Set-Aside Distribution (Government-Wide):**
- Full & Open: 60-70%
- Small Business (any): 20-25%
- SDVOSB: 1-2%
- 8(a): 3-5%
- HUBZone: 2-3%
- WOSB: 3-5%

**Government-Wide Goal:** 3% SDVOSB participation

### VA-Specific SDVOSB Market

**VA SDVOSB Contracts:** 1,026 contracts in software services (NAICS 541511/541512/541519)

**VA Market Share:** **12.8%** of VA software contracts

**Comparison:** 6-10x higher than government-wide average

**VA Set-Aside Distribution:**
- Full & Open: ~87%
- SDVOSB: **12.8%**
- Other set-asides: ~0.2%

**Validation:** VA has strong institutional preference for SDVOSB in IT contracts, making SDVOSB certification significantly more valuable at VA than other agencies.

### SDVOSB Average Contract Values

**VA SDVOSB Average Contract Value:** $215M
- Skewed by large platform deals ($100M-$500M)
- V3Gate: $576M (Salesforce)
- Four Points: $406M (AWS)
- MetGreen: $312M (ServiceNow)

**Custom Development Segment Average:** $2M-$25M
- A6's actual market segment
- More representative for digital services firms
- Task orders under IDIQs typically $500K-$10M

**Interpretation:** Don't use $215M average as A6's target. Platform deals dominate the average, but A6 competes in custom development segment.

## NAICS Code Distribution

### VA Software Contract NAICS Breakdown

**Primary NAICS Codes:**
- **541512** (Computer Systems Design Services): **~65%** of VA software contracts
- **541519** (Other Computer Related Services): **~30%** of VA software contracts
- **541511** (Custom Computer Programming Services): **~5%** of VA software contracts

**Critical Insight:** A6's primary NAICS (541511) is the LEAST common at VA. NAICS 541512 dominates.

**Search Strategy Implication:** Lead with 541512 in VA opportunity searches, not 541511.

### A6 NAICS Codes and Strategic Use

| NAICS Code | Description | SBA Small Business Status | Strategic Use at VA |
|------------|-------------|---------------------------|---------------------|
| **541511** | Custom Computer Programming Services | **Yes (Primary)** | 5% of VA contracts - A6's primary but least common |
| **541512** | Computer Systems Design Services | Yes | **65% of VA contracts** - most important for searches |
| **541519** | Other Computer Related Services | Exception (E) | 30% of VA contracts - catch-all category |
| 541611 | Administrative Management Consulting | No (N) | Program management support (minimal) |
| 611420 | Computer Training | No (N) | Minimal use |
| 611430 | Professional Development Training | No (N) | Minimal use |

**Search Order Priority:**
1. 541512 (leads 65% of contracts)
2. 541519 (30% of contracts)
3. 541511 (5% of contracts, but A6's primary)

**Query Format:** Use array format: `["541512", "541511", "541519"]`

## PSC Code Analysis

### Common PSC Codes in VA Software Contracts

| PSC Code | Official Title | Usage at VA | A6 Strategic Fit |
|----------|---------------|-------------|------------------|
| **DA01** | IT and Telecom - Business Application/App Development Support (Labor) | High | **Perfect fit** - User research, HCD, DevSecOps, UX |
| **D302** | IT and Telecom - Systems Development | High | Strong fit - Systems development & integration |
| **R408** | Support - Professional: Program Management/Support Services | Medium | Good fit - Program management support |
| 7A21 | ADP Support Services | Medium | Possible fit - IT support services |
| J063 | Maintenance/Repair/Rebuild of Equipment - Security Systems | Low | Poor fit - Physical security (not A6's capability) |
| DA10 | ADP Support Services (Labor) | Medium | Possible fit - IT staffing support |

**High-Priority PSC Codes for A6:**
- DA01 (Application Development - core A6 work)
- D302 (Systems Development - common at VA)
- R408 (Program Management - A6 supports this)

**Pass on PSC Codes:**
- J063 (Physical security systems)
- PSC codes for hardware procurement
- PSC codes for facilities/construction

### PSC Code Search Strategy

**Primary Search:**
```javascript
{
  psc_code: "DA01",  // or ["DA01", "D302", "R408"] for multiple
  naics_code: ["541512", "541511", "541519"]
}
```

**Broad Discovery:**
```javascript
{
  psc_code: ["DA01", "D302", "R408", "DA10", "7A21"],  // Cast wider net
  naics_code: ["541512", "541511", "541519"]
}
```

## Contract Size Analysis

### A6 Historical Performance

**All-Time Performance:**
- Total Contracts: 44 contracts
- Total Obligations: $224,358,307
- Average per contract: ~$5.1M
- Range: Likely $500K to $25M (based on FY2024 data)

**Active Portfolio:**
- Active Contracts: 16 contracts
- Active Obligations: $80,393,138
- Average per active contract: ~$5.0M

**IDIQ/BPA Infrastructure:**
- Total IDVs: 8 vehicles
- Active IDVs: 5 vehicles
- Task orders awarded through vehicles (specific count not available)

**Subaward Activity:**
- Subawards received: 12 subawards
- Subaward obligations: $14,277,560
- Average subaward: ~$1.2M

### FY2024 Contract Distribution

**Top 5 Contracts:**
1. Veterans Appointment and Check-In Experience: **$22.7M**
2. ABD Toxic Exposure: **$5.0M**
3. Health Enrollment Follow-On: **$5.0M**
4. New Cedar TO - Sitewide Product Team Support: **$4.7M**
5. Automated Benefits Delivery Applications: **$4.2M**

**Distribution:**
- 1 contract: $20M+ range (outlier)
- 4 contracts: $4M-$5M range (typical)
- Remaining 5 contracts: Unknown (likely $500K-$3M range)

**Set-Aside Distribution (FY2024):**
- SDVOSBC (competitive): 4 contracts
- SDVOSBS (sole source): 1 contract
- NONE (full & open): 5 contracts

**Insight:** A6 wins both set-aside AND unrestricted competitions, demonstrating competitiveness beyond certification advantage.

### Contract Size Guidance

**A6 Capacity Sweet Spot:**
- **Minimum viable:** $500K (below this, overhead not worth it)
- **Ideal range:** $2M-$25M (historical performance, capacity sweet spot)
- **Stretch maximum:** $50M (requires teaming/hiring)
- **Pass threshold:** <$500K (unless strategic relationship builder)

**Market Reality at VA:**
- Platform deals: $100M-$500M (subcontract only)
- Custom development: $2M-$25M (A6's segment)
- Task orders: $500K-$10M (common under IDIQs)
- Small projects: <$500K (not worth it)

**Qualification Strategy:**
```javascript
// No obligated_min/max parameters exist - filter client-side
// Use ordering to prioritize larger contracts:
{
  ordering: "-obligated",  // Largest contracts first
  limit: 100               // Get a sample to filter
}
// Then filter results client-side for $2M-$25M range
```

## Fiscal Year Trends

### FY2024 Performance (Agile Six)

**Contract Count:** 10 contracts awarded

**Customer Distribution:**
- VA: 9 contracts (90%)
- HHS: 1 contract (10%)

**Set-Aside Distribution:**
- SDVOSBC: 4 contracts
- SDVOSBS: 1 contract
- Full & Open: 5 contracts

**Contracting Office:**
- VA Technology Acquisition Center NJ (36C10B): Primary office

**Key Observations:**
- Maintains 90% VA concentration
- Winning full & open competitions (50% of awards)
- Diversification started with HHS (Simpler Grants)

### Multi-Year Trends (VA Market)

**SDVOSB Usage Growth:**
- SDVOSB set-asides increasing in IT contracts
- VA institutional commitment to veteran-owned businesses
- Platform deals increasingly include SDVOSB requirements

**Digital Services Demand:**
- VA.gov modernization driving custom development demand
- Forms digitization pipeline growing
- Mobile app development expanding
- Accessibility compliance retrofitting needed

**Market Shifts:**
- More task order competitions (vs standalone contracts)
- IDIQ/BPA vehicle importance growing
- Teaming becoming more common on large deals

## Customer Concentration Analysis

### Current State (FY2024)

**Revenue by Agency:**
- Department of Veterans Affairs: **90%**
- Department of Health and Human Services: **10%**
- Other agencies: **0%**

**Risk Level:** **VERY HIGH**
- Single customer concentration
- VA represents single point of failure
- Agency budget cuts would devastate A6

**Contracting Office Concentration:**
- VA Technology Acquisition Center NJ (36C10B): Primary office
- Risk: Relationship-dependent, single office concentration

### Target Diversification State

**Recommended Distribution:**
- VA: 60-70% (reduce but maintain primary customer)
- HHS: 20-30% (expand proven capability)
- GSA/TTS: 5-10% (new customer)
- Other agencies: 5-10% (opportunistic)

**Timeline:** 2-3 years to achieve target distribution

**Strategy:**
- Don't abandon VA (still best market for A6)
- Build on HHS success (Simpler Grants)
- Pursue similar citizen-facing work at other agencies
- Leverage SDVOSB at agencies beyond VA

## Market Opportunity Sizing

### Total Addressable Market (TAM)

**VA Software Services Market:**
- Total value: $X billion (based on 7,986 contracts)
- SDVOSB segment: 12.8% of VA market
- A6's custom development segment: 30-40% of SDVOSB market

**A6's Serviceable Addressable Market (SAM):**
- VA SDVOSB custom development: 30-40% of 12.8% = ~4-5% of VA software market
- Contract size filter ($2M-$25M): Further reduces to ~2-3% of VA market
- A6's current share: 0.X% of VA market (room to grow)

### Growth Potential

**Within VA:**
- Current: $80M active obligations
- Market share potential: 2-3x current size (based on segment analysis)
- Capacity ceiling: ~$150M-$200M annual (requires scaling)

**Through Diversification:**
- HHS market: Similar size to VA in digital services
- GSA/TTS market: Smaller but aligned
- Other agencies: Opportunistic
- Total potential: $200M-$300M annual (with diversification + VA growth)

**Constraints:**
- Staffing capacity (need to hire)
- Contract vehicle access (need OASIS+, GSA MAS)
- Past performance at new agencies (chicken-egg problem)
- Teaming relationships (for larger deals)

## Reference Data Tables

### Set-Aside Code Reference

| Code | Set-Aside Type | Strategic Value for A6 |
|------|---------------|------------------------|
| QF | SDVOSB Competitive | Primary advantage, 12.8% at VA |
| QX | SDVOSB Sole Source | Streamlined, relationship-based |
| A5 | VOSB | Secondary certification |
| 27 | Small Disadvantaged Business | Additional set-aside access |
| NONE | Full & Open Competition | A6 wins these too (50% of FY2024) |

### NAICS Code Reference

| NAICS | Description | Small Business Size Standard | Notes |
|-------|-------------|------------------------------|-------|
| 541511 | Custom Computer Programming Services | $34M annual receipts | A6's primary NAICS |
| 541512 | Computer Systems Design Services | $30M annual receipts | Most common at VA (65%) |
| 541519 | Other Computer Related Services | $30M annual receipts | Catch-all (30% at VA) |
| 541611 | Administrative Management and General Management Consulting Services | $25M annual receipts | Program management |
| 611420 | Computer Training | $11.5M annual receipts | Minimal A6 use |
| 611430 | Professional and Management Development Training | $11.5M annual receipts | Minimal A6 use |

**Size Standard Note:** A6 qualifies as small business for all primary NAICS codes.

### Agency Code Reference

| Agency Name | Common Code | Search String |
|-------------|-------------|---------------|
| Department of Veterans Affairs | VA | "Department of Veterans Affairs" |
| Department of Health and Human Services | HHS | "Department of Health and Human Services" |
| General Services Administration | GSA | "General Services Administration" |
| Technology Transformation Services | TTS | Use GSA + keyword filter |
| U.S. Digital Service | USDS | Search by partner agency |

### Contracting Office Reference

**VA Technology Acquisition Centers:**
- **36C10B** - VA TAC NJ (A6's primary office)
- Other VA TACs: Search by office code in awards data

**HHS Contracting Offices:**
- Varies by operating division (CMS, CDC, NIH, etc.)

**GSA Contracting Offices:**
- Multiple regional offices
- TTS-specific offices

## Data Sources and Validation

**Primary Data Source:** Tango MCP server (SAM.gov/USAspending.gov data)

**Data Currency:** 2024-2025 fiscal year data

**Validation Methods:**
- Cross-reference with SAM.gov entity records
- Verify against USAspending.gov public data
- Compare with company-reported performance
- Triangulate with competitor tracking

**Data Limitations:**
- Classification modifications may shift NAICS codes
- Contract amendments may change values
- Set-aside determinations can change during procurement
- Some task orders may not be fully captured

**Update Frequency:** Recommend monthly refresh of market data queries
