# Tango MCP Tools Reference

This file documents the tools available in the Tango MCP server. Use these tools to query federal data, analyze markets, and gather competitive intelligence.

## Tool Selection Guide

| Tool | Data Source | Use For |
|------|-------------|---------|
| `search_contracts` | FPDS (awarded) | Competitive intelligence, market sizing, recompetes |
| `search_opportunities` | SAM.gov (active) | Live bids, response deadlines |
| `search_forecasts` | Agency forecasts | Pipeline planning (VA has none) |
| `search_idvs` | FPDS | Contract vehicle analysis |
| `search_grants` | Grants.gov | Grant opportunities |

## Core Search Tools

### `search_contracts`
**Purpose:** Find awarded contracts from FPDS (past awards, competitive intelligence).

**WARNING:** Agency abbreviations (VA, DOD, DHS) do NOT work for `awarding_agency` or `funding_agency` parameters. Use full agency name (e.g., "Department of Veterans Affairs") or numeric code (e.g., "3600"). Use `lookup_agency` to find correct identifiers.

**Key Parameters:**
- `query`: Free-text search across descriptions
- `awarding_agency`: Full agency name or numeric code (abbreviations return 0 results)
- `vendor_name` / `vendor_uei`: Filter by contractor
- `naics_code`: Industry code as array (e.g., `["541512", "541511"]`)
- `set_aside_type`: e.g., "SDVOSB", "8A", "NONE"
- `award_date_start` / `award_date_end`: Date range for awards
- `expiration_date_after` / `expiration_date_before`: Find expiring contracts
- `fiscal_year`: Filter by fiscal year
- `ordering`: Sort field (prefix `-` for descending)
  - `-obligated` / `obligated`: Sort by contract value (largest/smallest first)
  - `-award_date` / `award_date`: Sort by award date (newest/oldest first)
- `shape`: Reduce payload by selecting fields (e.g., `"key,obligated,recipient(*),description"`)
- `limit`: Max results (default 10, max 100)
- `cursor`: Pagination cursor from previous response's `next_cursor`
- `export_format`: "json" (default) or "csv" for spreadsheet export

**Notes:**
- No `obligated_min/max` parameters exist. **Workaround:** Use `ordering: "-obligated"` to sort largest first, then filter client-side. Use `shape` to minimize payload when over-fetching.
- `set_aside` field often null in results

### `search_opportunities`
**Purpose:** Find active solicitations from SAM.gov (current bidding opportunities).

**Key Parameters:**
- `query`: Free-text search (use 1-2 keywords, AND logic)
- `agency`: Agency name
- `naics_code`: Industry code as array
- `set_aside_type`: Filter by set-aside
- `active`: `true` for open opportunities
- `notice_type`: `s` (solicitation), `p` (pre-solicitation), `r` (sources sought)
- `posted_date_after` / `posted_date_before`: Filter by posting date
- `response_deadline_after`: Filter by deadline
- `ordering`: Sort field (e.g., "-posted_date")
- `limit`: Max results
- `page`: Page number for pagination (integer, starts at 1)
- `export_format`: "json" or "csv"

**Pagination:** Uses page-based pagination (not cursor-based like other endpoints). Response includes `next_page` (integer or null on last page) and `total_pages`.

### `search_grants`
**Purpose:** Find grant opportunities from Grants.gov.

**Key Parameters:**
- `query`: Keywords
- `awarding_agency`: Agency filter
- `cfda_number`: Assistance listing number
- `naics_code`: Industry code as array
- `posted_date_after` / `posted_date_before`: Date filters
- `response_date_after` / `response_date_before`: Deadline filters
- `status`: "P" (Posted) or "F" (Forecasted)

### `search_idvs`
**Purpose:** Find Indefinite Delivery Vehicles (GWACs, IDIQs, BPAs).

**Key Parameters:**
- `idv_type`: `A` (GWAC), `B` (IDC/IDIQ), `C` (FSS/GSA Schedule), `D` (BOA), `E` (BPA)
- `expiring_after` / `expiring_before`: Find active or expiring vehicles
- `awarding_agency`: Agency filter
- `recipient_name` / `recipient_uei`: Vendor filter
- `naics_code`: Industry code as array

### `search_subawards`
**Purpose:** Find subcontracting data from FSRS (awards over $30,000).

**Key Parameters:**
- `prime_uei`: Filter by prime contractor (who issued the subaward)
- `sub_uei`: Filter by subcontractor (who received the subaward)
- `awarding_agency`: Agency filter
- `fiscal_year`: Year filter

**Returns:** Prime contractor name, subcontractor name, subaward amount, award details.

**Example - Find A6's subaward history:**
```javascript
search_subawards({ sub_uei: "UP4JHKJQ9MQ7" })
// Returns: 12 subawards from primes like SAIC, Liberty IT, Softrams
```

**Use for:** Teaming intelligence, identifying which primes subcontract to small businesses, competitive analysis.

### `search_forecasts`
**Purpose:** Find procurement forecasts (planned opportunities).

**Key Parameters:**
- `agency`: Agency acronym (e.g., "HHS", "DHS", "GSA")
- `naics_code`: Industry code as array
- `fiscal_year`: Planned FY
- `status`: "PUBLISHED", "DRAFT"
- `award_date_after` / `award_date_before`: Anticipated award date range

**WARNING:** VA does NOT publish forecasts to Tango. All 49 VA sub-agencies show `has_forecasts: false`. Use `search_opportunities` for VA pipeline visibility. HHS has 165+ forecasts in software services NAICS codes.

## Detail Tools

### `get_contract_detail`
**Purpose:** Get full data for a specific contract.
**Args:** `contract_key` (from search results, format: `CONT_AWD_xxxxx`)

### `get_opportunity_detail`
**Purpose:** Get full data for a specific solicitation.
**Args:** `opportunity_id` (UUID format)

### `get_grant_detail`
**Purpose:** Get full data for a specific grant.
**Args:** `grant_id` (integer)

### `get_forecast_detail`
**Purpose:** Get full data for a forecast item.
**Args:** `forecast_id` (integer)

## Intelligence & Analytics Tools

### `get_vendor_profile`
**Purpose:** Get SAM.gov entity registration data.
**Args:**
- `uei` (required, 12-character alphanumeric)
- `include_history`: Include contract/grant history (default: false)
- `history_limit`: Max history records (default: 10, max: 50)

**Use for:** Verifying certifications, size status, points of contact, federal obligations.

### `get_company_intelligence`
**Purpose:** AI-generated summary of a company, including news and key people.
**Args:** `company_name` (use exact legal name for best results)

**Note:** Name matching is imprecise. Use `get_vendor_profile` for compliance data.

### `get_spending_summary`
**Purpose:** Aggregate spending data (contracts/grants).

**Key Parameters:**
- `group_by`: `vendor`, `agency`, `naics`, `psc`, `month`
- `awarding_agency`: Filter by agency
- `vendor_uei`: Filter by vendor
- `fiscal_year`: Filter by FY
- `award_type`: "contracts", "grants", or "all"

**Use for:** "Who are the top vendors at VA?" or "What is the spending trend?"

### `get_agency_analytics`
**Purpose:** Agency-specific spending trends.

**Args:**
- `agency_code` (required) - **MUST be numeric code, not abbreviation**
- `fiscal_year`: Filter by FY
- `naics_code`: Filter by industry (array format, e.g., `["541512", "541511", "541519"]`)
- `include_trends`: Include monthly breakdown (default: false)

**Tip:** Always use `naics_code` filter for market-specific analysis. Without it, results include all agency contracts (utilities, medical equipment, etc.).

**Agency Codes (for get_agency_analytics):**
| Agency | Numeric Code |
|--------|--------------|
| VA | 3600 |
| HHS | 7500 |
| GSA | 4700 |
| DOD | 9700 |
| Education | 9100 |

**Note:** Using "VA" or "Veterans Affairs" returns no data. Must use "3600".

### `lookup_agency`
**Purpose:** Find agency codes and details.

**Key Parameters:**
- `query` (required): Name or acronym to search
- `departments_only`: When `true`, filters out sub-agencies and returns only parent departments
- `limit`: Max results (default 10, max 100)

**Note:** Parent departments now sort first in results. When searching "Veterans Affairs", the Department of Veterans Affairs (code 3600) appears first, not buried among sub-agencies. Use `departments_only: true` when you only need the main department. Also shows `has_forecasts` field.

## Response Metadata

All tool responses include an `execution` block with cache and timing information:

| Field | Type | Description |
|-------|------|-------------|
| `cached` | boolean | `true` if response came from cache |
| `cache_timestamp` | string\|null | ISO timestamp of when data was cached (`null` if fresh) |
| `duration_ms` | number | Response time in milliseconds |

**Example (fresh data):** `{ "cached": false, "cache_timestamp": null, "duration_ms": 612 }`

**Example (cached):** `{ "cached": true, "cache_timestamp": "2025-12-02T15:23:29.224Z", "duration_ms": 6 }`

Use `cache_timestamp` to understand data freshness when `cached: true`.

## Utility

### `health`
**Purpose:** Check server status.
