---
name: agile-six-brand
title: A6 Brand
description: Comprehensive Agile Six brand guidelines for creating on-brand materials, documents, and visual content. Use when working on Agile Six materials, branded documents, or when user requests "Agile Six brand", "A6 style", "company colors", or "brand-compliant". Provides official colors, typography, logo usage, and accessibility compliance (508).
---

# Agile Six Brand Guidelines

## Overview

This skill provides comprehensive Agile Six brand guidelines for creating consistent, professional, and accessible branded materials. It includes official brand colors, typography recommendations, logo usage rules, and application guidance.

**Keywords**: agile six, a6, brand guidelines, corporate identity, visual identity, brand colors, typography, logo, 508 compliance, accessibility

## Quick Reference

- **Brand Tagline**: "A better place to work. Better work to do."
- **Primary Brand Color**: Navy (#003A70)
- **Secondary Colors**: Light Blue (#41B6E6), Deep Red (#8A2A2B)
- **Typography**: Geometric sans-serif (Montserrat, Raleway, Gotham as system alternatives)
- **508 Accessibility**: All brand applications must meet Section 508 compliance

## Core Brand Elements

### Colors

See **[brand/colors.md](brand/colors.md)** for the complete color palette including:
- Exact hex codes and RGB values for all 5 brand colors
- Usage guidelines for each color
- 508 accessibility compliance notes
- Recommended color combinations and contrast ratios

**Quick Color Reference:**
- Navy: `#003A70` - Primary headers, main accents, backgrounds
- Light Blue: `#41B6E6` - Highlights, callouts, data visualization
- Light Grey: `#D9D9D6` - Subtle backgrounds, dividers
- Dark Grey: `#707372` - Body text, secondary elements
- Deep Red: `#8A2A2B` - Accent color, limited use

### Typography

See **[brand/typography.md](brand/typography.md)** for complete typography guidelines including:
- Recommended font families (Montserrat, Raleway, etc.)
- Typography hierarchy for different content types
- Accessibility requirements for font sizes and weights
- Logo typography characteristics
- Typography best practices and common mistakes

**Quick Typography Reference:**
- Title elements: 44pt bold headers, 28pt subtitles
- Content headers: 32pt headings, 18pt minimum body text
- Use geometric sans-serif fonts that complement the logo's aesthetic

### Logos

See **[brand/logo-usage.md](brand/logo-usage.md)** for detailed logo specifications including:
- All 4 logo types (Standard, With Tagline, Alt Logo, Social Icon)
- All 10 files covering 3 logo types × 3 color variants (navy, black, white) + social icon
- Logo placement rules for different contexts
- Minimum sizes and clear space requirements
- Background color guidelines
- Logo usage dos and don'ts

**Available Logo Assets (10 files, hierarchically organized):**

**Standard Logo** (3 variants):
- `assets/logos/standard/color/agile6_logo_rgb_large.png` - Navy for light backgrounds
- `assets/logos/standard/black/agile6_logo_k_large.png` - Black for grayscale
- `assets/logos/standard/white/agile6_logo_rev_large.png` - White for dark backgrounds

**Logo with Tagline** (3 variants):
- `assets/logos/with-tagline/color/agile6_logo_tag_rgb_large.png` - Navy for light backgrounds
- `assets/logos/with-tagline/black/agile6_logo_tag_k_large.png` - Black for grayscale
- `assets/logos/with-tagline/white/agile6_logo_tag_rev_large.png` - White for dark backgrounds

**Alt Logo with Prominent Tagline** (3 variants):
- `assets/logos/alt-logo/color/agile6_logo_alt_rgb_large.png` - Navy for light backgrounds
- `assets/logos/alt-logo/black/agile6_logo_alt_k.png` - Black for grayscale
- `assets/logos/alt-logo/white/agile6_logo_alt_rev_large.png` - White for dark backgrounds

**Social Media Icon** (1 file):
- `assets/logos/social-icon/agile6_social_icon_500x500.jpg` - Social media profiles

### Brand Voice & Essence

See **[brand/brand-essence.md](brand/brand-essence.md)** for:
- Brand tagline and its meaning
- Core brand values and personality
- Messaging guidelines and tone
- How brand essence informs visual design

## Brand Application Workflow

When creating Agile Six materials, follow this workflow:

### 1. Apply Brand Colors

- Use **Navy (#003A70)** for primary headers and key elements
- Use **Light Blue (#41B6E6)** for highlights, callouts, and accents
- Use **Dark Grey (#707372)** for body text
- Use **Light Grey (#D9D9D6)** for subtle backgrounds when needed
- Ensure sufficient contrast for 508 compliance (Navy on white = 12.6:1 contrast ratio)

### 2. Logo Placement and Selection

**CRITICAL - Logo Selection Based on Background:**
- **Navy or dark backgrounds**: Use WHITE logo (`agile6_logo_rev_large.png`)
- **White or light backgrounds**: Use NAVY logo (`agile6_logo_rgb_large.png`)
- **Never use navy logo on navy background** - contrast is terrible and fails accessibility

**Placement:**
- **Primary elements**: Use standalone logo prominently (2-3 inches wide)
- **Headers/footers**: Small logo (0.75-1 inch)
- Logo assets available in `assets/logos/` directory

### 3. Typography

- Choose geometric sans-serif fonts (Montserrat, Raleway, Gotham, or Calibri as fallback)
- Headers: 44pt bold titles, 28pt subtitles
- Body text: 18pt minimum
- Reflect the modern, clean geometric aesthetic of the brand

### 4. Accessibility Checklist

Before finalizing any material:

- ✓ Color contrast ratios meet WCAG 2.0 AA (minimum 4.5:1 for normal text)
- ✓ Text size minimum 18pt for body text (14pt only if bold)
- ✓ Alt text added for all images and logos
- ✓ Color not used as sole indicator of meaning
- ✓ Font weights sufficient for readability
- ✓ Line spacing adequate (1.5x for body text)


## Resources

### Brand Reference Files

- **[brand/colors.md](brand/colors.md)** - Complete color palette with accessibility notes
- **[brand/typography.md](brand/typography.md)** - Typography guidelines and font recommendations
- **[brand/logo-usage.md](brand/logo-usage.md)** - Logo specifications and usage rules
- **[brand/brand-essence.md](brand/brand-essence.md)** - Brand values, voice, and messaging

### Assets

- **Logo files**: `assets/logos/` directory
- **Brand guide PDF**: `assets/guidelines/agilesix_branding_quickguide.pdf` (official source document)

## Example Usage Scenarios

### Scenario 1: Creating Branded Marketing Materials

**User**: "Create Agile Six materials about our Q4 results"

**Claude applies**:
- Navy headers with white text for primary sections
- White backgrounds with navy headers and dark grey text for body content
- Light blue accents for key metrics and data visualization
- Charts using navy (primary), light blue (secondary), deep red (accent)
- 508-compliant text sizes (18pt minimum)
- Logo prominently displayed

### Scenario 2: Brand Color Query

**User**: "What colors should I use for Agile Six materials?"

**Claude responds** with:
- Navy (#003A70) as primary
- Light Blue (#41B6E6) as secondary
- Complete palette with usage guidelines
- Accessibility considerations

### Scenario 3: Quick Reference Document

**User**: "Make quick A6 branded document for team standup"

**Claude applies**:
- Minimal brand treatment
- White backgrounds, navy headers
- Logo in header
- Focus on content over heavy branding
- Fast, clean execution

## Brand Compliance Notes

### What Makes Content "On-Brand"

✓ Uses official brand colors (especially navy as primary)
✓ Geometric, clean typography
✓ Proper logo usage and placement
✓ Modern, professional aesthetic
✓ Meets 508 accessibility standards
✓ Reflects brand values (quality, people-first, public service)

### Common Brand Mistakes to Avoid

❌ Using non-brand colors
❌ Stretching or distorting the logo
❌ Text too small (<18pt body text)
❌ Poor contrast ratios
❌ Decorative fonts that clash with geometric brand aesthetic
❌ Recreating logo with system fonts
❌ Missing alt text on images

## Updates and Maintenance

This skill is based on the Agile Six branding quick guide (available in `assets/guidelines/`). If brand guidelines are updated, the following files should be reviewed and updated accordingly:

- `brand/colors.md` - If color palette changes
- `brand/typography.md` - If font recommendations change
- `brand/logo-usage.md` - If new logo variations are released
- `assets/logos/` - Add new logo files as they become available

For questions about brand guidelines or to request updates to this skill, consult the official brand guide PDF.
