# Agile Six Logo Assets

This directory contains the complete hierarchical set of official Agile Six logo files for use in documents and branded materials.

## Directory Structure

All 10 logo files are organized by type and color variant:

```
assets/logos/
├── standard/
│   ├── color/
│   │   └── agile6_logo_rgb_large.png
│   ├── black/
│   │   └── agile6_logo_k_large.png
│   └── white/
│       └── agile6_logo_rev_large.png
├── with-tagline/
│   ├── color/
│   │   └── agile6_logo_tag_rgb_large.png
│   ├── black/
│   │   └── agile6_logo_tag_k_large.png
│   └── white/
│       └── agile6_logo_tag_rev_large.png
├── alt-logo/
│   ├── color/
│   │   └── agile6_logo_alt_rgb_large.png
│   ├── black/
│   │   └── agile6_logo_alt_k.png
│   └── white/
│       └── agile6_logo_alt_rev_large.png
└── social-icon/
    └── agile6_social_icon_500x500.jpg
```

## Available Logo Files - Complete List

### Standard Logo (3 variants)

**Type**: Standard wordmark logo (preferred for most uses)

#### 1. Standard Logo - Navy/Color (for light backgrounds)
**File**: `standard/color/agile6_logo_rgb_large.png`

- **Description**: The primary Agile Six logo featuring the "agilesix" wordmark in navy
- **Format**: PNG with transparency
- **Color**: Navy (#003A70)
- **Dimensions**: 1412 x 425 pixels
- **Minimum size**: 1 inch
- **Usage**:
  - White or light grey backgrounds
  - Content sections with light backgrounds
  - Headers and footers on light backgrounds
  - Official documents with light backgrounds
  - Website and digital applications on light backgrounds
  - General business materials
- **Accessibility**: PASS on white backgrounds (meets WCAG 2.1 AA)
- **Best for**: Digital documents, web content

#### 2. Standard Logo - Black (for grayscale)
**File**: `standard/black/agile6_logo_k_large.png`

- **Description**: Black version of the standard Agile Six logo
- **Format**: PNG with transparency
- **Color**: Black (#000000)
- **Dimensions**: 1412 x 425 pixels
- **Minimum size**: 1 inch
- **Usage**:
  - Black and white printing
  - Grayscale materials
  - Documents with monochrome requirements
- **Accessibility**: PASS on white backgrounds

#### 3. Standard Logo - White/Reversed (for dark backgrounds)
**File**: `standard/white/agile6_logo_rev_large.png`

- **Description**: Reversed (white) Agile Six logo for dark backgrounds
- **Format**: PNG with transparency
- **Color**: White (#FFFFFF)
- **Dimensions**: 1412 x 425 pixels
- **Minimum size**: 1 inch
- **Usage**:
  - Navy (#003A70) backgrounds
  - Title sections with navy backgrounds
  - Closing sections with navy backgrounds
  - Any dark background application
- **Accessibility**: CRITICAL for dark backgrounds to meet WCAG 2.1 AA
- **⚠️ CRITICAL**: Always use white/reversed on navy/dark backgrounds - never use navy logo on navy background (fails contrast/accessibility requirements)

### Logo with Tagline (3 variants)

**Type**: Logo with tagline "A better place to work. Better work to do."
**Minimum size**: 1.75 inches
**Best for**: Marketing materials, recruiting documents, brand-building contexts

#### 4. Logo with Tagline - Navy/Color
**File**: `with-tagline/color/agile6_logo_tag_rgb_large.png`

- **Description**: Standard logo plus tagline in navy on light backgrounds
- **Format**: PNG with transparency
- **Color**: Navy (#003A70)
- **Dimensions**: 1600 x 236 pixels
- **Aspect Ratio**: 6.78:1
- **Usage**: Marketing and recruiting materials on light backgrounds
- **Accessibility**: PASS on white backgrounds

#### 5. Logo with Tagline - Black
**File**: `with-tagline/black/agile6_logo_tag_k_large.png`

- **Description**: Standard logo plus tagline in black (grayscale)
- **Format**: PNG with transparency
- **Color**: Black (#000000)
- **Dimensions**: 1600 x 236 pixels
- **Aspect Ratio**: 6.78:1
- **Usage**: Grayscale marketing materials, B&W printing, recruiting documents
- **Accessibility**: PASS on white backgrounds

#### 6. Logo with Tagline - White/Reversed
**File**: `with-tagline/white/agile6_logo_tag_rev_large.png`

- **Description**: Standard logo plus tagline in white (for dark backgrounds)
- **Format**: PNG with transparency
- **Color**: White (#FFFFFF)
- **Dimensions**: 1600 x 236 pixels
- **Aspect Ratio**: 6.78:1
- **Usage**: Marketing materials with dark backgrounds, recruiting on navy
- **Accessibility**: CRITICAL for maintaining tagline visibility on dark backgrounds

### Alt Logo with Prominent Tagline (3 variants)

**Type**: Logo with larger, more prominent tagline
**Minimum size**: 1.75 inches
**Best for**: Brand messaging campaigns, when tagline needs emphasis

#### 7. Alt Logo - Navy/Color
**File**: `alt-logo/color/agile6_logo_alt_rgb_large.png`

- **Description**: Logo with larger, more prominent tagline in navy
- **Format**: PNG with transparency
- **Color**: Navy (#003A70)
- **Dimensions**: 1600 x 200 pixels
- **Aspect Ratio**: 8:1
- **Usage**: Tagline-focused materials and campaigns on light backgrounds
- **Accessibility**: PASS on white backgrounds

#### 8. Alt Logo - Black
**File**: `alt-logo/black/agile6_logo_alt_k.png`

- **Description**: Logo with larger, prominent tagline in black
- **Format**: PNG with transparency
- **Color**: Black (#000000)
- **Dimensions**: 832 x 104 pixels
- **Aspect Ratio**: 8:1
- **Usage**: Grayscale tagline emphasis, B&W brand campaigns
- **Accessibility**: PASS on white backgrounds

#### 9. Alt Logo - White/Reversed
**File**: `alt-logo/white/agile6_logo_alt_rev_large.png`

- **Description**: Logo with larger, prominent tagline in white
- **Format**: PNG with transparency
- **Color**: White (#FFFFFF)
- **Dimensions**: 1600 x 200 pixels
- **Aspect Ratio**: 8:1
- **Usage**: Tagline emphasis on dark backgrounds, brand campaigns (dark)
- **Accessibility**: CRITICAL for dark backgrounds

### Social Media Icon (1 file)

#### 10. Social Media Icon
**File**: `social-icon/agile6_social_icon_500x500.jpg`

- **Description**: Simplified "a" icon on navy background with light blue accent bar
- **Format**: JPG (no transparency needed)
- **Dimensions**: 500 x 500 pixels (square, 1:1 aspect ratio)
- **Minimum size**: 21 pixels tall
- **Design elements**:
  - Navy (#003A70) background field
  - White lowercase letter "a" (large, centered)
  - Light blue (#41B6E6) horizontal accent bar
- **Usage**:
  - Social media profile images
  - Small icons and favicons
  - Footer elements (small scale)
  - Digital avatars
  - App icons
  - Email signatures
- **Note**: Not for primary branding contexts (use standalone logo instead)

## Logo Usage Guidelines

### Quick Reference

✅ **Do:**
- Use official logo files as provided
- Maintain clear space (equal to height of "a" in logo)
- Place on approved backgrounds (white, light grey, navy)
- Ensure minimum sizes (Standard: 1", Tagline: 1.75", Social: 21px)
- Provide alt text for accessibility
- Keep aspect ratio locked when resizing
- Choose color variant based on background (Navy on light, White on dark)

❌ **Don't:**
- Stretch or distort the logo
- Change logo colors
- Add effects (shadows, glows, gradients)
- Rotate the logo
- Recreate logo with system fonts
- Place on low-contrast or busy backgrounds
- Remove or modify logo elements
- Use navy logo on navy/dark backgrounds (accessibility failure)

### Minimum Sizes by Logo Type

| Logo Type | Minimum Size |
|-----------|--------------|
| Standard Logo | 1 inch (25.4 mm) |
| Logo with Tagline | 1.75 inches (44.5 mm) |
| Alt Logo | 1.75 inches (44.5 mm) |
| Social Media Icon | 21 pixels tall |

### Clear Space

Maintain clear space around the logo equal to the height of the lowercase "a" in "agilesix". No text, graphics, or other elements should appear within this clear space zone.

### Accessibility

Always include descriptive alt text:
- **Standard logo**: "Agile Six logo"
- **Logo with tagline**: "Agile Six: A better place to work. Better work to do."
- **Social icon**: "Agile Six"

**Critical accessibility rule**: Always verify background contrast. Use white/reversed logo on dark backgrounds to meet WCAG 2.1 AA standards.

## File Formats

### PNG Format
- **Files in this skill**: 9 files (standard, with-tagline, and alt-logo)
- **Advantages**: Transparency support, lossless compression, high quality
- **Best for**: Web, digital documents, layering on any background
- **Color profile**: RGB
- **Extensions**: `.png`

### JPG Format
- **Files in this skill**: 1 file (social icon)
- **Advantages**: Smaller file size, universal compatibility
- **Best for**: Social media platforms, email signatures, icons
- **Limitation**: No transparency support
- **Extensions**: `.jpg`

## Logo Selection Decision Tree

For guidance on which logo to use in different scenarios, see:
**[../reference/logo-selection-guide.md](../reference/logo-selection-guide.md)**

Quick decision matrix:
- **Standard Logo**: General use, limited space
- **Logo with Tagline**: Marketing, recruiting, brand reinforcement
- **Alt Logo**: Tagline emphasis, brand campaigns
- **Social Icon**: Social media profiles, small icons

## Complete Logo Documentation

For comprehensive logo usage guidelines including placement rules, background requirements, and brand compliance information, see:

**[../brand/logo-usage.md](../brand/logo-usage.md)**

This file contains:
- Detailed specifications for all 4 logo types
- Logo placement guidelines for different contexts
- Comprehensive dos and don'ts
- Accessibility considerations
- Special use cases and file management

---

**Last Updated**: November 17, 2025 (Asset Integration Complete)
**Hierarchical Structure**: Implemented with all 10 files organized by type and color variant
**Skill Version**: 1.0.0
