# Accessibility Standards

**Version**: 1.0
**Last Updated**: November 17, 2025
**Sources**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Page 8; Agent 1 PDF Extraction

## Overview

Agile Six is committed to creating accessible, inclusive digital experiences that serve everyone. Our accessibility standards are based on WCAG 2.1 AA conformance and Section 508 compliance requirements.

**Core Principle**: "User-friendly, accessible, and inclusive government services for everyone."

## WCAG 2.1 AA Conformance

### What is WCAG 2.1 AA?

**WCAG**: Web Content Accessibility Guidelines
**Version**: 2.1 (current standard)
**Level**: AA (mid-level conformance)

WCAG 2.1 AA is the internationally recognized standard for web accessibility and is required for U.S. federal government digital services.

**Four Principles (POUR)**:
1. **Perceivable**: Information and user interface components must be presentable to users in ways they can perceive
2. **Operable**: User interface components and navigation must be operable
3. **Understandable**: Information and the operation of user interface must be understandable
4. **Robust**: Content must be robust enough to be interpreted by a wide variety of user agents, including assistive technologies

**Source**: W3C Web Accessibility Initiative; [AgileSix_styleguide_DRAFT5.pdf, Page 8]

## Color Contrast Requirements

### Minimum Contrast Ratios

**WCAG 2.1 AA Standards**:

| Text Size | Minimum Contrast Ratio | Passes |
|-----------|----------------------|--------|
| **Normal text** (< 18pt regular, < 14pt bold) | **4.5:1** | AA |
| **Large text** (≥ 18pt regular, ≥ 14pt bold) | **3.0:1** | AA |
| **Enhanced** (AAA standard) | **7.0:1** | AAA |

**Agile Six Standard**: Meet or exceed WCAG 2.1 AA for all text

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 8]; WCAG 2.1 Guidelines

### Agile Six Color Contrast Matrix

The following table shows which Agile Six brand colors pass WCAG standards when paired with different backgrounds:

| Foreground Color | On White | On Navy (#003A70) | On Light Grey (#D9D9D6) |
|------------------|----------|-------------------|------------------------|
| **Blue (Navy)** #003A70 | ✅ AAA (12.6:1) | ❌ Fail | ✅ AAA (9.2:1) |
| **Dark Grey** #707372 | ✅ AA (4.7:1) | ❌ Fail | ❌ Fail |
| **Cyan** #41B6E6 | ❌ Fail (2.3:1) | ✅ AA (4.9:1) | ❌ Fail |
| **Dark Cyan** #007CBB | ✅ AA (4.5:1) | ❌ Fail | ✅ AA (3.3:1) |
| **Red** #8A2A2B | ✅ AAA (7.4:1) | ✅ AA (1.7:1)* | ✅ AA (5.4:1) |
| **Light Gray** #D9D9D6 | ❌ Fail (1.4:1) | ✅ AAA (9.0:1) | ❌ Fail |
| **Light Blue** #D7E0EB | ❌ Fail (1.2:1) | ✅ AAA (10.5:1) | ❌ Fail |
| **White** #FFFFFF | ❌ Fail | ✅ AAA (12.6:1) | ❌ Fail (1.5:1) |

**Legend**:
- ✅ AA = Passes WCAG 2.1 AA (4.5:1 for normal text, 3.0:1 for large text)
- ✅ AAA = Exceeds to AAA level (7.0:1+)
- ❌ Fail = Does not meet WCAG 2.1 AA standards
- * = May pass for large text only

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 8]; WCAG 2.1 contrast calculations

### Recommended Safe Color Pairings

**Always Accessible**:
1. **Navy (#003A70) on White** - 12.6:1 (AAA)
2. **White on Navy (#003A70)** - 12.6:1 (AAA)
3. **Dark Grey (#707372) on White** - 4.7:1 (AA)
4. **Red (#8A2A2B) on White** - 7.4:1 (AAA)
5. **Cyan (#41B6E6) on Navy (#003A70)** - 4.9:1 (AA)

**For Large Text Only** (≥ 18pt regular, ≥ 14pt bold):
- Light Grey (#D9D9D6) on Navy (#003A70)
- Light Blue (#D7E0EB) on Navy (#003A70)
- Dark Cyan (#007CBB) on Light Grey (#D9D9D6)

**Never Use for Text**:
- Cyan (#41B6E6) on White - fails WCAG
- Light Grey (#D9D9D6) on White - fails WCAG
- Light Blue (#D7E0EB) on White - fails WCAG
- Any pairing that fails 4.5:1 ratio for normal text

**Source**: [Color Palette](colors.md) specifications

## Alternative Text for Images

### Alt Text Requirements

**WCAG Requirement**: All non-decorative images must have alternative text that describes the image content.

**Best Practices**:

**DO**:
- Describe what's in the image concisely (1-2 sentences)
- Include relevant context and information the image conveys
- Describe actions, settings, and key visual elements
- For complex images (charts, diagrams), provide detailed description
- For military imagery, include service branch and relevant context

**DON'T**:
- Start with "Image of..." or "Picture of..." (screen readers already announce it's an image)
- Use vague descriptions like "photo" or "graphic"
- Exceed 250 characters if possible (be concise)
- Include information already in surrounding text
- Describe decorative images (use alt="" for purely decorative)

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; WCAG 2.1 Guidelines

### Alt Text Examples

**Good Alt Text**:
- "Three Agile Six team members collaborating on laptops in a modern office"
- "Navy Veteran using prosthetic leg works at standing desk with dual monitors"
- "Chart showing 85% increase in user satisfaction over 6 months"

**Poor Alt Text**:
- "Image" (too vague)
- "Photo of people" (not descriptive enough)
- "Picture of a chart" (doesn't describe what chart shows)

**Decorative Images**:
- `alt=""` (empty alt attribute for purely decorative images)

**Source**: [Imagery Guidelines](imagery-guidelines.md); WCAG 2.1

### Complex Images

For complex images (charts, diagrams, infographics):
- Provide brief alt text describing the image type and topic
- Provide detailed description in surrounding text OR
- Use `longdesc` attribute or `aria-describedby` for extended descriptions
- Consider providing data table equivalent for complex charts

**Example**:
```html
<img src="user-satisfaction-chart.png"
     alt="Bar chart showing user satisfaction trends Q1-Q4 2024"
     aria-describedby="chart-description">
<div id="chart-description">
  Detailed description: User satisfaction increased from 65% in Q1
  to 85% in Q4, with steady growth each quarter...
</div>
```

**Source**: WCAG 2.1 Guidelines; Best practices for data visualization

## Accessible PDF Creation

### PDF Accessibility Requirements

**Required Elements**:
1. **Tagged content** - All content must be properly tagged
2. **Heading structure** - Use proper heading hierarchy (H1, H2, H3)
3. **Alternative text** - All images must have alt text
4. **Logical reading order** - Content flows in correct sequence
5. **Form field labels** - All form fields properly labeled
6. **Document language** - Language of document specified
7. **Document title** - Meaningful title in document properties

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 8]; Section 508 standards

### Creating Accessible PDFs

**In Microsoft Word (Before Converting to PDF)**:
1. Use built-in heading styles (Heading 1, Heading 2, etc.)
2. Add alt text to all images
3. Use lists (bulleted/numbered) properly
4. Create tables with header rows
5. Use meaningful hyperlink text (not "click here")
6. Check reading order in Accessibility Checker
7. Set document language

**When Converting to PDF**:
- Use "Save as PDF" with "Best for accessibility and reflow" option
- Do NOT use print-to-PDF (loses accessibility features)
- Verify tags in resulting PDF

**In Adobe Acrobat Pro (For Remediation)**:
1. Run Accessibility Checker
2. Add tags if missing
3. Set reading order
4. Add/edit alt text for images
5. Verify form fields have labels
6. Set document properties (title, author, language)
7. Add bookmarks for long documents

**Source**: Adobe Accessibility Guidelines; Section 508 standards

### Testing PDF Accessibility

**Tools**:
- Adobe Acrobat Pro Accessibility Checker
- PAC (PDF Accessibility Checker) - free tool
- Screen reader testing (NVDA, JAWS, VoiceOver)

**Checklist**:
- [ ] All content tagged
- [ ] Heading hierarchy logical
- [ ] Images have alt text
- [ ] Reading order correct
- [ ] Tables have headers
- [ ] Form fields labeled
- [ ] Color not sole information carrier
- [ ] Document properties set
- [ ] Passes automated checker
- [ ] Tested with screen reader

**Source**: Section 508 checklist; WCAG 2.1

## Keyboard Navigation

### Requirements

**All functionality must be operable via keyboard alone**, without requiring specific timings for individual keystrokes.

**Key Requirements**:
- All interactive elements accessible via Tab key
- Logical tab order through content
- Visible focus indicators
- No keyboard traps (can navigate away from all elements)
- Keyboard shortcuts don't conflict with assistive technology

**Common Keyboard Shortcuts**:
- **Tab**: Move forward through interactive elements
- **Shift+Tab**: Move backward through interactive elements
- **Enter/Space**: Activate buttons and links
- **Arrow keys**: Navigate within components (menus, radio groups)
- **Esc**: Close dialogs, cancel actions

**Source**: WCAG 2.1 Guidelines; Keyboard accessibility standards

### Testing Keyboard Navigation

**How to Test**:
1. Unplug mouse or don't use it
2. Use only keyboard to navigate entire page/document
3. Verify you can reach all interactive elements
4. Check that focus indicator is visible
5. Ensure no elements trap keyboard focus
6. Verify logical tab order

**Pass Criteria**:
- All content reachable via keyboard
- Tab order makes sense
- Focus always visible
- Can complete all tasks

**Source**: WCAG 2.1 testing procedures

## Screen Reader Compatibility

### Screen Reader Requirements

**Content must be compatible with screen readers** including:
- JAWS (Job Access With Speech)
- NVDA (NonVisual Desktop Access)
- VoiceOver (macOS/iOS)
- TalkBack (Android)
- Narrator (Windows)

**Best Practices**:
- Use semantic HTML (headings, lists, nav, main, etc.)
- Provide text alternatives for non-text content
- Use ARIA labels only when semantic HTML insufficient
- Ensure content makes sense when read aloud
- Test with actual screen readers

**Source**: WCAG 2.1 Guidelines; Assistive technology compatibility

### Semantic HTML Structure

**Use proper HTML elements**:
- `<header>`, `<nav>`, `<main>`, `<footer>` for page structure
- `<h1>` through `<h6>` for headings (don't skip levels)
- `<button>` for buttons (not `<div>` with click handler)
- `<a>` for links
- `<ul>`/`<ol>` for lists
- `<table>` with `<th>` for data tables

**Why**: Screen readers use semantic HTML to understand page structure and provide navigation shortcuts.

**Source**: WCAG 2.1; HTML accessibility best practices

## Information Design

### Never Use Color Alone

**Requirement**: "Never use color alone to convey information"

**Why**: Users with color blindness or visual impairments may not perceive color differences.

**Best Practices**:

**DO**:
- ✅ Use color PLUS icons, labels, or patterns
- ✅ Underline links in addition to color
- ✅ Use different patterns in charts (not just colors)
- ✅ Label chart elements directly
- ✅ Use text labels for status indicators

**DON'T**:
- ❌ Rely solely on color to distinguish chart elements
- ❌ Use only color to indicate errors (add icon and text)
- ❌ Make links distinguishable only by color
- ❌ Use color alone for "before/after" comparisons

**Examples**:

**Good** (chart legend):
- Blue circle + "Completed"
- Red square + "In Progress"
- Green triangle + "Planned"

**Poor** (chart legend):
- Blue line (unlabeled)
- Red line (unlabeled)
- Green line (unlabeled)

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 8]; WCAG 2.1 Guideline 1.4.1

## External Resources

### W3C Web Accessibility Initiative
- WCAG 2.1 Guidelines: https://www.w3.org/WAI/WCAG21/quickref/
- Understanding WCAG 2.1: https://www.w3.org/WAI/WCAG21/Understanding/

### WebAIM
- Contrast Checker: https://webaim.org/resources/contrastchecker/
- Screen Reader Testing: https://webaim.org/articles/screenreader_testing/
- Articles and Resources: https://webaim.org/articles/

### Adobe Accessibility
- Creating Accessible PDFs: https://www.adobe.com/accessibility/pdf/pdf-accessibility-overview.html
- Acrobat Pro Accessibility Tools: https://helpx.adobe.com/acrobat/using/creating-accessible-pdfs.html

### Section 508
- Section 508 Standards: https://www.section508.gov/
- Testing Tools: https://www.section508.gov/test/

### Testing Tools
- WAVE (Web Accessibility Evaluation Tool): https://wave.webaim.org/
- axe DevTools (browser extension): https://www.deque.com/axe/devtools/
- Lighthouse (built into Chrome DevTools)
- Color Contrast Analyzer: https://www.tpgi.com/color-contrast-checker/
- PAC (PDF Accessibility Checker): https://pdfua.foundation/en/pdf-accessibility-checker-pac/

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 8]

## Accessibility Workflow

### Design Phase
1. Choose accessible color combinations (4.5:1+ contrast)
2. Plan semantic heading structure
3. Design visible focus indicators
4. Include text labels in addition to color coding
5. Plan alt text for images
6. Ensure touch targets minimum 44x44px

### Development Phase
1. Use semantic HTML elements
2. Add ARIA labels where needed
3. Implement keyboard navigation
4. Add alt text to images
5. Ensure proper heading hierarchy
6. Test with keyboard only

### Testing Phase
1. Run automated accessibility checker
2. Test with keyboard navigation
3. Test with screen reader
4. Verify color contrast
5. Check alt text quality
6. Review with actual users with disabilities if possible

### Documentation Phase
1. Document accessibility features
2. Provide accessibility statement
3. Include VPAT (Voluntary Product Accessibility Template) if required
4. Note any known limitations

**Source**: Accessibility best practices; Agile development workflow

## Agile Six Accessibility Checklist

Before publishing any digital content, verify:

### Visual Accessibility
- [ ] Color contrast meets WCAG 2.1 AA (4.5:1 for text)
- [ ] Information not conveyed by color alone
- [ ] Text is resizable up to 200% without loss of content
- [ ] Visual focus indicator visible on all interactive elements

### Content Accessibility
- [ ] All images have descriptive alt text
- [ ] Headings used in logical hierarchy
- [ ] Link text is descriptive (not "click here")
- [ ] Lists use proper HTML list elements
- [ ] Tables have proper headers

### Navigation Accessibility
- [ ] All functionality available via keyboard
- [ ] Tab order is logical
- [ ] No keyboard traps
- [ ] Skip navigation links provided (for long pages)

### Technical Accessibility
- [ ] Semantic HTML used throughout
- [ ] ARIA labels added where needed
- [ ] Form fields properly labeled
- [ ] Error messages descriptive and associated with fields
- [ ] Page language specified
- [ ] Document title meaningful

### PDF Accessibility (if applicable)
- [ ] PDF tagged for accessibility
- [ ] Images in PDF have alt text
- [ ] Reading order logical
- [ ] Document properties set
- [ ] Passes Adobe Acrobat Accessibility Checker

### Testing
- [ ] Automated checker passed (WAVE, axe, Lighthouse)
- [ ] Manual keyboard testing completed
- [ ] Screen reader testing completed
- [ ] Color contrast verified
- [ ] Tested on multiple browsers/devices

**Source**: Compiled from WCAG 2.1, Section 508, and Agile Six standards

---

## See Also

- [Color Palette](colors.md) - Color contrast specifications
- [Typography Guidelines](typography.md) - Font sizes and accessibility
- [Imagery Guidelines](imagery-guidelines.md) - Alt text requirements
- [Print Specifications](print-specifications.md) - Accessible print materials

---

**Version**: 1.0 | **Last Updated**: November 17, 2025 | **Sources**: AgileSix_styleguide_DRAFT5.pdf, Page 8; WCAG 2.1 Guidelines
