# Agile Six Brand Essence

## Brand Tagline

**"A better place to work. Better work to do."**

This two-part tagline encapsulates the core of Agile Six's mission and values:

### Part 1: "A better place to work"
- **Focus**: Internal culture and employee experience
- **Meaning**: Commitment to creating excellent workplace environments
- **Values**: People-first approach, employee wellbeing, positive culture
- **Promise**: To employees and potential hires

### Part 2: "Better work to do"
- **Focus**: External impact and work quality
- **Meaning**: Dedication to meaningful, high-quality outcomes
- **Values**: Public service, mission-driven, quality over quantity
- **Promise**: To clients and the communities served

### Tagline Structure

- **Format**: Two separate lines, aligned left (or centered depending on context)
- **Typography**: Clean, modern sans-serif matching document font
- **Color**: Navy (#003A70) on light backgrounds, white on navy backgrounds
- **Usage**: Include when brand message needs emphasis (external materials, marketing)

## Brand Values (Inferred from Identity)

### 1. People-Centric Culture
**"A better place to work"**

- Prioritizes employee wellbeing and satisfaction
- Creates environments where people can thrive
- Values work-life balance and employee growth
- Builds teams based on trust and collaboration
- Recognizes that great work comes from great teams

### 2. Mission-Driven Excellence
**"Better work to do"**

- Focuses on meaningful outcomes over mere deliverables
- Serves the public good as core motivation
- Pursues quality and impact in every project
- Takes pride in work that makes a difference
- Aligns business success with social value

### 3. Modern Professionalism

- Forward-thinking in approach and methods
- Professional without being stiff or corporate
- Balances structure with agility
- Embraces innovation and continuous improvement

### 4. Accessibility as Core Value

- 508 compliance built into brand identity
- Inclusive by design, not afterthought
- Reflects commitment to serving all users
- Demonstrates values through design choices

## Brand Voice Characteristics

### Tone Attributes

**Clear and Direct**
- Uses straightforward language
- Avoids jargon and corporate speak
- Gets to the point efficiently
- Values clarity over cleverness

**Professional Yet Approachable**
- Serious about mission and quality
- Not stuffy or overly formal
- Friendly without being casual
- Competent and confident

**Human-Centered**
- Emphasizes people and impact
- Speaks to values, not just features
- Acknowledges human experience
- Shows empathy and understanding

**Optimistic and Forward-Looking**
- Focus on improvement and progress
- "Better" as recurring theme
- Solutions-oriented mindset
- Positive but realistic

**Quality-Focused**
- Emphasis on excellence and craft
- Takes work seriously
- Thorough and thoughtful
- Attention to detail matters

## Visual Brand Personality

### Design Language

**Geometric and Structured**
- Clean lines and organized layouts
- Systematic approach to composition
- Reflects methodical, thoughtful process
- Professional and polished execution

**Modern and Contemporary**
- Current design trends and aesthetics
- Forward-looking, not traditional
- Tech-savvy and innovative appearance
- Stays relevant and fresh

**Balanced and Harmonious**
- Navy (traditional/trustworthy) + Light Blue (modern/approachable)
- Serious mission + people-first culture
- Professional + accessible
- Structure + flexibility

**Accessible and Inclusive**
- 508 compliance as foundational principle
- High contrast and readable typography
- Design choices support all users
- Values reflected in visual decisions

### Color Personality

**Navy (#003A70) - Primary Brand Color**
- **Attributes**: Trust, professionalism, stability, government/public service
- **Message**: Serious about mission, reliable, established
- **Usage**: Foundation of brand, primary identifier

**Light Blue (#41B6E6) - Secondary Accent**
- **Attributes**: Modern, approachable, innovation, clarity
- **Message**: Forward-thinking, accessible, friendly
- **Usage**: Balances navy's seriousness with optimism

**Deep Red (#8A2A2B) - Tertiary Accent**
- **Attributes**: Passion, importance, energy
- **Message**: Care deeply about work and impact
- **Usage**: Strategic emphasis, limited application

**Greys - Supporting Neutrals**
- **Attributes**: Professionalism, sophistication, balance
- **Message**: Thoughtful, refined, not flashy
- **Usage**: Supporting structure, readable text

## Messaging Guidelines

### What Agile Six Stands For

✓ Creating excellent workplace culture
✓ Delivering meaningful, impactful work
✓ Serving the public good
✓ Valuing people and their wellbeing
✓ Pursuing quality and excellence
✓ Operating with integrity and professionalism
✓ Embracing accessibility and inclusion

### Key Messages

1. **Work-Life Quality**: We create workplaces where people thrive
2. **Mission Impact**: We do work that matters and serves the public
3. **Excellence**: Quality and thoughtfulness in everything we do
4. **People First**: Our success comes from our people
5. **Public Service**: Committed to improving government digital services

### Voice Examples

**Instead of**: "Agile Six provides digital transformation services"
**Say**: "We help government agencies deliver better digital experiences for the people they serve"

**Instead of**: "Our company culture prioritizes team satisfaction"
**Say**: "We build a better place to work because we know great work comes from great teams"

**Instead of**: "We follow accessibility standards"
**Say**: "We design for all users from the start, because accessibility isn't optional—it's essential"

## Application to Materials

When creating Agile Six materials, reflect brand essence through:

### 1. Content Approach

- **Lead with impact**: Focus on outcomes and value delivered
- **Show the work**: Demonstrate quality through examples and details
- **Acknowledge people**: Highlight team contributions and collaboration
- **Be clear**: Use straightforward language, avoid jargon
- **Stay focused**: Quality over quantity in content

### 2. Visual Execution

- **Professional polish**: Attention to detail in all design elements
- **Accessible design**: Meet 508 requirements as standard practice
- **Clean layouts**: Organized, structured, geometric composition
- **Brand consistency**: Use official colors, typography, and logo correctly
- **Modern aesthetic**: Contemporary design that feels current

### 3. Tone in Content Text

- **Concise**: Get to the point efficiently
- **Clear**: No ambiguity or jargon
- **Impact-focused**: Emphasize value and outcomes
- **Professional**: Competent and confident without being boastful
- **Human**: Remember there are people behind the work

### 4. Storytelling

- **Problem → Solution → Impact**: Standard narrative structure
- **Show before and after**: Demonstrate improvement
- **Quantify when possible**: Metrics that matter
- **Include human element**: How work affects real people
- **Connect to mission**: Link to public service and impact

## Brand Essence in Different Contexts

### External Client Materials

- Full brand treatment with logo and tagline
- Emphasize both culture ("better place to work") and delivery ("better work to do")
- Professional, polished, comprehensive
- Show case studies and impact
- Reflect brand values through design quality

### Internal Team Communications

- Can be more casual while maintaining professionalism
- Emphasize team and culture
- Focus on "better place to work" aspect
- Still maintain brand visual consistency
- Content over heavy branding

### Recruiting Materials

- Heavily emphasize "better place to work"
- Showcase culture and values
- Use full logo with tagline
- Show team and workplace
- Demonstrate commitment to employees

### Case Studies / Portfolio

- Focus on "better work to do"
- Show impact and outcomes
- Demonstrate quality and thoroughness
- Include metrics and results
- Connect work to public service mission

## Brand Personality Spectrum

```
Traditional ←→ Modern: Leaning Modern (70/30)
Serious ←→ Playful: Balanced with slight Serious (60/40)
Corporate ←→ Casual: Professional but Approachable (65/35)
Loud ←→ Quiet: Confident and Clear, not Loud (40/60)
Exclusive ←→ Inclusive: Strongly Inclusive (20/80)
```

## Competitive Differentiation

What makes Agile Six distinct:

1. **Dual focus**: Both workplace quality AND work quality (not just one)
2. **Public service mission**: Dedicated to government digital services
3. **Accessibility-first**: 508 compliance as core value, not checkbox
4. **People-centric**: Culture as competitive advantage
5. **Quality-driven**: Thorough, thoughtful, excellent execution

## Brand Essence Summary

**Who we are**: A digital services company serving government agencies

**What we do**: Deliver high-quality digital solutions that improve public services

**How we work**: By creating excellent workplaces that enable people to do their best work

**Why it matters**: Because better teams create better outcomes for the people we serve

**Our promise**: A better place to work AND better work to do

**Visual identity**: Modern geometric aesthetic with accessible, professional design

**Brand personality**: Professional yet approachable, mission-driven, people-first, quality-focused

---

**Remember**: Every document, material, and visual communication should reflect these brand values through both content and design choices. The tagline isn't just words—it's a commitment that should be visible in everything we create.
