# Agile Six Color Palette

**Version**: 2.0
**Last Updated**: November 17, 2025
**Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Pages 7-8

## Overview

The Agile Six brand palette consists of 7 colors divided into primary and secondary groups. All colors are specified in multiple formats to support both digital and print applications.

## Primary Brand Colors

### Blue (Navy) - PMS 654
- **Hex**: `#003A70`
- **RGB**: 0, 58, 112
- **CMYK**: 100 / 71 / 10 / 47
- **Pantone**: PMS 654
- **Usage**: Primary brand color. "Use the blue versions of the logos whenever possible." Use for headers, main accents, backgrounds, text emphasis, and logo.
- **Accessibility**: PASS on white (meets WCAG 2.1 AA standards)
- **Contrast Ratio**: 12.6:1 with white (WCAG AAA compliant)
- **When to use**: Title backgrounds, primary headers, key callouts, branding elements
- **Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]; [agilesix_branding_quickguide.pdf, Page 2]

### Dark Grey - PMS 424
- **Hex**: `#707372`
- **RGB**: 112, 115, 114
- **CMYK**: 30 / 20 / 19 / 58
- **Pantone**: PMS 424
- **Usage**: Part of primary color palette. Body text, secondary text, borders, subtle elements.
- **Accessibility**: PASS on white (meets WCAG 2.1 AA standards)
- **Contrast Ratio**: 4.7:1 with white (WCAG AA compliant)
- **When to use**: Body text, secondary headings, captions, borders
- **Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]; [agilesix_branding_quickguide.pdf, Page 2]

### Cyan - PMS 298
- **Hex**: `#41B6E6`
- **RGB**: 65, 182, 230
- **CMYK**: 67 / 2 / 0 / 0
- **Pantone**: PMS 298
- **Usage**: Part of primary color palette. Highlights, callouts, data visualization, secondary accents.
- **Accessibility**: Pass on navy; Large text on red (meets WCAG 2.1 standards for large text only on red)
- **Contrast Ratio**: 4.9:1 with navy (WCAG AA compliant)
- **When to use**: Chart elements, highlights, interactive elements, accents on dark backgrounds
- **Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]; [agilesix_branding_quickguide.pdf, Page 2]

### Dark Cyan - PMS 7461
- **Hex**: `#007CBB`
- **RGB**: 0, 124, 187
- **CMYK**: 100 / 34 / 0 / 27
- **Pantone**: PMS 7461
- **Usage**: Part of primary color palette. Data visualization, charts, secondary accents.
- **Accessibility**: Not explicitly stated in accessibility chart
- **When to use**: Data visualization requiring multiple color series, chart elements, accent variations
- **Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

## Secondary Colors

**Usage Note**: "The secondary colors listed may be used as supplementary colors."

### Red - PMS 7623
- **Hex**: `#8A2A2B`
- **RGB**: 138, 42, 43
- **CMYK**: 0 / 97 / 87 / 53
- **Pantone**: PMS 7623
- **Usage**: Accent color, alerts, emphasis (use sparingly)
- **Accessibility**: PASS on white (meets WCAG 2.1 AA standards)
- **Contrast Ratio**: 7.4:1 with white (WCAG AAA compliant)
- **When to use**: Tertiary accent in charts, limited decorative use, error states
- **Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]; [agilesix_branding_quickguide.pdf, Page 2]

### Light Gray - PMS Cool Grey 1
- **Hex**: `#D9D9D6`
- **RGB**: 217, 217, 214
- **CMYK**: 4 / 2 / 4 / 8
- **Pantone**: PMS Cool Grey 1
- **Usage**: Subtle backgrounds, dividers, secondary elements, light fills.
- **Accessibility**: Pass on navy and red; Large text on dark grey (meets WCAG 2.1 standards for large text only on dark grey)
- **When to use**: Background fills for alternate sections, subtle dividers, secondary elements
- **Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]; [agilesix_branding_quickguide.pdf, Page 2]

### Light Blue - PMS 650
- **Hex**: `#D7E0EB`
- **RGB**: 215, 224, 235
- **CMYK**: 17 / 6 / 3 / 0
- **Pantone**: PMS 650
- **Usage**: Very light backgrounds, subtle accents. "The secondary colors listed may be used as supplementary colors."
- **Accessibility**: Not explicitly stated in accessibility chart
- **When to use**: Very subtle backgrounds, light accent areas, secondary fills
- **Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

## Print Color Specifications

### PMS (Pantone Matching System)
"The listed PMS colors will render the most accurate printing of the brand colors. This type of printing uses a standardized ink formula that allows for consistency across the world. This is best for 1 or 2-color jobs."

**When to use PMS**:
- Logo printing
- Brand-critical color matching
- Spot color printing
- 1-2 color print jobs

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

### CMYK (4-Color Process)
"For four-color process reproduction, the CMYK builds that are shown are those that best match the Pantone colors. This is best for brochures, flyers, and marketing collateral."

**When to use CMYK**:
- Full-color brochures
- Flyers and marketing materials
- Photography and full-color images
- Cost-sensitive multi-color projects

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

### Digital Color Specifications

**RGB**: "RGB is used for defining colors on desktop software and online applications."

**HEX**: "HEX is primarily used for web design."

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

### Color Accuracy Disclaimer

"Color will vary from printer to printer and monitor to monitor. The only way to ensure accurate reproduction is to use a professional printer and have the printer print using Pantone inks."

"The colors shown throughout this manual have not been evaluated by Pantone, Inc., for accuracy and may not match the PANTONE Color Standards. Please refer to the current edition of the Pantone color formula guide. PANTONE is a registered trademark of Pantone, Inc."

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

## Color Combinations for 508 Compliance

### ✅ Recommended Pairings

1. **Navy (#003A70) + White (#FFFFFF)**
   - Contrast ratio: 12.6:1
   - Compliance: WCAG AAA
   - Use for: Title sections, primary headers, key text

2. **Dark Grey (#707372) + White (#FFFFFF)**
   - Contrast ratio: 4.7:1
   - Compliance: WCAG AA
   - Use for: Body text, paragraphs, captions

3. **Light Blue (#41B6E6) + Navy (#003A70)**
   - Contrast ratio: 4.9:1
   - Compliance: WCAG AA
   - Use for: Highlighted text on navy backgrounds, chart elements

4. **Deep Red (#8A2A2B) + White (#FFFFFF)**
   - Contrast ratio: 7.4:1
   - Compliance: WCAG AAA
   - Use for: Accent elements, warnings

5. **White (#FFFFFF) + Navy (#003A70)**
   - Contrast ratio: 12.6:1
   - Compliance: WCAG AAA
   - Use for: Text on navy backgrounds, title sections

### ⚠️ Use with Caution

- **Light Blue (#41B6E6) on White**: Low contrast (2.3:1) - fails WCAG standards
- **Light Grey (#D9D9D6) on White**: Very low contrast (1.4:1) - use for decorative only
- **Light Grey text**: Only use on dark backgrounds (navy, dark grey)

### ❌ Avoid

- Light grey text on white backgrounds (insufficient contrast)
- Light blue text on white backgrounds (insufficient contrast)
- Light blue text on light grey backgrounds (very poor contrast)
- Small text (<18pt) in light blue on any background except navy

## Application Guidelines

### Primary Headers and Titles
- **Background**: Navy (#003A70)
- **Title text**: White (#FFFFFF)
- **Subtitle text**: White (#FFFFFF) or Light Blue (#41B6E6)
- **Logo**: Standalone logo in white or full color

### Body Content
- **Background**: White (#FFFFFF)
- **Headers**: Navy (#003A70)
- **Body text**: Dark Grey (#707372)
- **Accents**: Light Blue (#41B6E6) for highlights
- **Borders**: Light Grey (#D9D9D6) or Dark Grey (#707372)

### Section Dividers
- **Background**: Light Blue (#41B6E6) or Navy (#003A70)
- **Text**: White (#FFFFFF) or Navy if on light blue background
- **Logo**: Small corner placement

### Data Visualization / Charts
- **Primary data series**: Navy (#003A70)
- **Secondary data series**: Light Blue (#41B6E6)
- **Tertiary data series**: Deep Red (#8A2A2B)
- **Additional series**: Dark Grey (#707372), Light Grey (#D9D9D6)
- **Background**: White (#FFFFFF)
- **Text**: Dark Grey (#707372) or Navy (#003A70)

### Callout Boxes / Highlights
- **Background**: Light Blue (#41B6E6) at 20-30% opacity on white
- **Border**: Navy (#003A70) or Light Blue (#41B6E6)
- **Text**: Navy (#003A70) or Dark Grey (#707372)

### Footer Elements
- **Background**: Light Grey (#D9D9D6) or White (#FFFFFF)
- **Text**: Dark Grey (#707372)
- **Divider line**: Dark Grey (#707372) or Navy (#003A70)

## Accessibility Guidelines

### Minimum Contrast Ratios (WCAG 2.0 AA)
- **Normal text** (< 18pt regular, < 14pt bold): 4.5:1
- **Large text** (≥ 18pt regular, ≥ 14pt bold): 3.0:1
- **Agile Six standard**: Meet or exceed AA for all text

### Color Usage Best Practices

1. **Never use color alone** to convey information
   - ✅ Use icons, labels, or patterns in addition to color
   - ❌ Don't rely solely on color to distinguish chart elements

2. **Test contrast** before finalizing
   - Use online contrast checkers for color combinations
   - Ensure all text meets minimum contrast ratios

3. **Consider colorblind users**
   - Navy and light blue are distinguishable for most color vision deficiencies
   - Avoid relying on red/green distinctions (use navy/light blue instead)

4. **Maintain brand integrity**
   - Don't modify brand colors for "better contrast"
   - Instead, choose appropriate color pairings from the approved palette

## Complete Color Specifications Reference

### All 7 Brand Colors

| Color Name | Hex | PMS | RGB | CMYK |
|------------|-----|-----|-----|------|
| **Blue (Navy)** | #003A70 | 654 | 0, 58, 112 | 100 / 71 / 10 / 47 |
| **Dark Grey** | #707372 | 424 | 112, 115, 114 | 30 / 20 / 19 / 58 |
| **Cyan** | #41B6E6 | 298 | 65, 182, 230 | 67 / 2 / 0 / 0 |
| **Dark Cyan** | #007CBB | 7461 | 0, 124, 187 | 100 / 34 / 0 / 27 |
| **Red** | #8A2A2B | 7623 | 138, 42, 43 | 0 / 97 / 87 / 53 |
| **Light Gray** | #D9D9D6 | Cool Grey 1 | 217, 217, 214 | 4 / 2 / 4 / 8 |
| **Light Blue** | #D7E0EB | 650 | 215, 224, 235 | 17 / 6 / 3 / 0 |

### Contrast Accessibility Reference

| Color       | Hex       | On White | On Navy   | On Light Grey |
|-------------|-----------|----------|-----------|---------------|
| Blue (Navy) | #003A70   | ✅ AAA    | ❌        | ✅ AAA        |
| Dark Grey   | #707372   | ✅ AA     | ❌        | ❌            |
| Cyan        | #41B6E6   | ❌        | ✅ AA     | ❌            |
| Dark Cyan   | #007CBB   | ✅ AA     | ❌        | ✅ AA         |
| Red         | #8A2A2B   | ✅ AAA    | ✅ AA     | ✅ AA         |
| Light Gray  | #D9D9D6   | ❌        | ✅ AAA    | ❌            |
| Light Blue  | #D7E0EB   | ❌        | ✅ AAA    | ❌            |
| White       | #FFFFFF   | ❌        | ✅ AAA    | ❌            |

**Legend**: ✅ = Passes WCAG standards, ❌ = Fails WCAG standards

**Source**: Accessibility grid from [AgileSix_styleguide_DRAFT5.pdf, Page 8]

## Color Codes for Copy-Paste

### Hex Codes (Most Common)
```
Blue (Navy):  #003A70
Dark Grey:    #707372
Cyan:         #41B6E6
Dark Cyan:    #007CBB
Red:          #8A2A2B
Light Gray:   #D9D9D6
Light Blue:   #D7E0EB
White:        #FFFFFF
```

### RGB Values
```
Blue (Navy):  0, 58, 112
Dark Grey:    112, 115, 114
Cyan:         65, 182, 230
Dark Cyan:    0, 124, 187
Red:          138, 42, 43
Light Gray:   217, 217, 214
Light Blue:   215, 224, 235
```

### CMYK Values (For Print)
```
Blue (Navy):  100 / 71 / 10 / 47
Dark Grey:    30 / 20 / 19 / 58
Cyan:         67 / 2 / 0 / 0
Dark Cyan:    100 / 34 / 0 / 27
Red:          0 / 97 / 87 / 53
Light Gray:   4 / 2 / 4 / 8
Light Blue:   17 / 6 / 3 / 0
```

### Pantone PMS Codes (For Print)
```
Blue (Navy):  PMS 654
Dark Grey:    PMS 424
Cyan:         PMS 298
Dark Cyan:    PMS 7461
Red:          PMS 7623
Light Gray:   PMS Cool Grey 1
Light Blue:   PMS 650
```

---

## See Also

- [Typography Guidelines](typography.md) - Font specifications and sizing
- [Accessibility Standards](accessibility-standards.md) - WCAG 2.1 AA compliance details
- [Print Specifications](print-specifications.md) - Detailed print production guidance
- [Logo Usage](logo-usage.md) - Logo color variants and usage rules

---

**Version**: 2.0 | **Last Updated**: November 17, 2025 | **Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5)
