# Copywriting Guidelines

**Version**: 1.0
**Last Updated**: November 17, 2025
**Sources**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Agent 2 Voice/Tone Analysis

## Overview

Effective copywriting at Agile Six requires accuracy in military and government terminology, consistency in brand language, and appropriate voice and tone for each audience.

## Capitalization Rules for Military and Government Terms

### ALWAYS Capitalize

**"Veteran"** - ALWAYS CAPITALIZED
- ✅ CORRECT: "Veteran," "Veterans"
- ❌ INCORRECT: "veteran," "veterans"
- **Why**: Shows respect for military service
- **When**: In all contexts referring to people who have served in the military

**Source**: Agent 1 PDF Extraction; Military style guides

**Service Member Titles** (When Referring to Branches):
- ✅ CORRECT: "Soldier" (Army), "Sailor" (Navy), "Airman" (Air Force), "Marine" (Marine Corps), "Guardsman" (Coast Guard)
- **Usage**: Capitalize when referring to the specific role within that branch
- **Example**: "She is a Soldier in the U.S. Army."

**Military Service Names**:
- ✅ CORRECT: "U.S. Army," "U.S. Navy," "U.S. Air Force," "U.S. Marine Corps," "U.S. Coast Guard," "U.S. Space Force"
- **Always capitalize** the full service name and branch
- **Example**: "He served in the Marine Corps."

**Military Ranks (When Part of a Name/Title)**:
- ✅ CORRECT: "Captain Smith," "General Johnson," "Sergeant Martinez"
- **When**: Rank is used as part of someone's title or name
- **Example**: "Captain Smith presented the briefing."

**Government Agency Names (First Reference)**:
- ✅ CORRECT: "Department of Veterans Affairs (VA)," "Centers for Medicare & Medicaid Services (CMS)"
- **First reference**: Full name capitalized
- **Subsequent references**: Acronym acceptable
- **Example**: "The Department of Veterans Affairs (VA) announced... The VA will implement..."

**Source**: Agent 1 PDF Extraction; Federal government style guide

### DO NOT Capitalize

**"service member"** (Generic Use):
- ✅ CORRECT: "service member," "service members"
- ❌ INCORRECT: "Service Member"
- **When**: Used generically, not as a specific title
- **Example**: "We serve service members and Veterans."

**Source**: Agent 1 PDF Extraction

**"service provider"** (Non-Military Context):
- ✅ CORRECT: "service provider"
- **Context**: Referring to companies or organizations providing services (not military personnel)

**"reserves" and "reserve component"**:
- ✅ CORRECT: "reserves," "reserve component"
- ❌ INCORRECT: "Reserves," "Reserve Component"
- **Exception**: "Reserve" when part of official unit name (e.g., "Army Reserve")

**Source**: Agent 1 PDF Extraction

**Military Ranks (When Not Part of Name)**:
- ✅ CORRECT: "The captain said..." "She was promoted to sergeant."
- ❌ INCORRECT: "The Captain said..."
- **When**: Rank used generically, not as part of someone's title
- **Example**: "Three captains attended the meeting."

**Source**: Agent 1 PDF Extraction; AP Style

### Conditional Capitalization

**Military Titles**:
- ✅ Capitalize: When used as part of a name or title
- ✅ Lowercase: When used generically or not as title

**Examples**:
- "Captain Smith briefed the team." (capitalized - part of name)
- "The captain briefed the team." (lowercase - generic use)
- "She is a captain in the Army." (lowercase - describing rank)

**Agency Names**:
- ✅ Capitalize: Full agency name on first reference
- ✅ Use acronym: After first reference (still capitalized)
- ✅ Lowercase: Generic references to "the agency" or "the department"

**Examples**:
- "The Department of Veterans Affairs (VA) serves millions of Veterans." (first reference)
- "The VA provides healthcare..." (subsequent reference)
- "The department's mission is..." (generic reference)

**Source**: Agent 1 PDF Extraction; Federal Plain Language Guidelines

## Tagline Punctuation (CRITICAL)

### Correct Format

**CORRECT**: "A better place to work. Better work to do."

- **Two sentences** with period separator
- **First sentence**: "A better place to work."
- **Second sentence**: "Better work to do."

**Source**: Agent 1 PDF Extraction; Agent 2 Voice/Tone Analysis

### Incorrect Formats

❌ **WRONG**: "A better place to work, better work to do." (comma incorrect)
❌ **WRONG**: "A better place to work - better work to do." (dash incorrect)
❌ **WRONG**: "A better place to work: better work to do." (colon incorrect)

**Why This Matters**: The tagline is a core brand element. Consistent punctuation ensures brand recognition and professional polish.

**Source**: Agent 1 PDF Extraction

## Voice and Tone by Material Type

### Recruiting and Marketing Materials

**Tone**: Warm, authentic, human-centered, inspiring

**Characteristics**:
- Aspirational and welcoming
- Values-driven language
- Inclusive ("everyone," "authentic selves")
- Action-oriented ("pursue," "build," "create")
- Personal and relatable

**Sentence Structure**:
- Mix of short punchy sentences (5-8 words)
- Longer descriptive sentences (20+ words)
- Varied rhythm keeps content engaging

**Paragraph Length**: 2-4 sentences

**Emotional Register**: Aspirational, welcoming, empowering

**Example Phrases**:
- "We pursue work that matters."
- "Build a career with purpose."
- "Bring your authentic self to work."
- "A people-first, fully remote company."

**Source**: Agent 2 Voice/Tone Analysis, Recruiting Materials

### Client-Facing and Proposals

**Tone**: Professional, confident, partnership-oriented, outcome-focused

**Characteristics**:
- Government-fluent language
- Partnership language ("shoulder-to-shoulder")
- Outcome-focused ("extraordinary outcomes")
- Competent and credible
- Collaborative framing

**Sentence Structure**:
- Longer, more complex sentences
- Information-dense
- Professional formality

**Paragraph Length**: 3-5 sentences

**Emotional Register**: Competent, credible, partnership-oriented

**Example Phrases**:
- "Partnering with [Agency] to modernize..."
- "Serves shoulder-to-shoulder with federal agencies"
- "Create extraordinary outcomes"
- "Innovative, human-centered solutions"
- "Using modern technology and design"

**Source**: Agent 2 Voice/Tone Analysis, Client-Facing Materials

### Internal and Process Documents

**Tone**: Direct, transparent, informative, supportive

**Characteristics**:
- Clear and directive
- Transparent communication
- Values-aware even in process docs
- Supportive and accommodating
- Action-oriented

**Sentence Structure**:
- Short, directive sentences
- Clear instructions
- Frequent breaks for readability

**Paragraph Length**: 2-3 sentences with frequent breaks

**Format**: Numbered lists, bold emphasis, clear sections

**Emotional Register**: Transparent, supportive, direct

**Example Structure**:
- Numbered action steps
- Clear expectations
- Bold key points
- Direct language

**Source**: Agent 2 Voice/Tone Analysis, Internal Documents

## Standard Brand Phrases

### Company Descriptors

| Context | Phrase | Source |
|---------|--------|--------|
| Company type | "people-first, fully remote company" | Agent 2 |
| Partnership approach | "serves shoulder-to-shoulder with federal agencies" | Agent 2 |
| Solution type | "innovative, human-centered solutions" | Agent 2 |
| Service description | "user-friendly, accessible, and inclusive government services" | Agent 2 |
| Audience | "for everyone" | Agent 2 |
| Work approach | "putting people first in everything we do" | Agent 2 |

### Values Language

| Value | Standard Phrase | Source |
|-------|----------------|--------|
| Values introduction | "our core values are our North Star" | Agent 2 |
| Purpose | "We pursue work that matters." | Agent 2 |
| Wholeness | "We hold space for people to be their complete and authentic selves." | Agent 2 |
| Trust | "We build relationships based on trust—among teammates, customers, and partners." | Agent 2 |
| Self-Management | "We reinforce autonomy (no managers here!) and local decision-making" | Agent 2 |
| Inclusion | "We see, hear, and value people." | Agent 2 |

### Differentiation Language

| Context | Phrase | Source |
|---------|--------|--------|
| What sets us apart | "What sets Agile Six apart is our ability to create extraordinary outcomes" | Agent 2 |
| Team description | "purpose-driven cross-disciplinary teams" | Agent 2 |
| Delivery approach | "healthy delivery ecosystems" | Agent 2 |
| Relationships | "trust-based relationships with partners and stakeholders" | Agent 2 |

**Source**: Agent 2 Voice/Tone Analysis, Boilerplate Text Library

## Terminology Guidelines

### Preferred Terms

**People-First Language**:
- ✅ "person with a disability" (not "disabled person")
- ✅ "Veteran" (always capitalized)
- ✅ "service member" (lowercase when generic)
- ✅ "team member" or "Sixer" (Agile Six employee)

**Government Context**:
- ✅ "federal agency" or "government agency"
- ✅ "citizen" or "the public" (for end users)
- ✅ "stakeholder" (internal government partners)

**Work Context**:
- ✅ "remote-first" (not "remote-only")
- ✅ "fully remote company"
- ✅ "self-managed" (not "self-managing")
- ✅ "cross-disciplinary teams" (not "cross-functional")

**Source**: Agent 2 Voice/Tone Analysis; Agile Six brand documents

### Terms to Avoid

**Avoid**:
- ❌ "customer" (use "partner" or "client" for government agencies)
- ❌ "vendor" (use "partner" to describe Agile Six's role)
- ❌ "deliverable" (use "outcome" or "solution")
- ❌ Jargon without explanation
- ❌ Military abbreviations without context (except well-known like VA, DoD)

**Source**: Agent 2 Voice/Tone Analysis

## Agency Partnership Description Format

### Template

```
[In support of / Partnering with] [AGENCY NAME] [to achieve goal],
Agile Six [is/was verb-ing] [specific work] [that results in outcome].
```

### Examples

**VA (Department of Veterans Affairs)**:
> "In support of VA's Digital Modernization effort to create an exceptional user experience, Agile Six is implementing digital services that make it easier for Veterans and VA stakeholders to access the services and support they deserve."

**CMS (Centers for Medicare & Medicaid Services)**:
> "Partnering with CMS to modernize complex Medicare payment systems, Agile Six is utilizing user research and human-centered design to reduce burden and improve outcomes."

**CDC (Centers for Disease Control and Prevention)**:
> "In support of CDC's Pandemic Readiness and Data Modernization Initiative to modernize core data and surveillance infrastructure, Agile Six is creating integrated, real-time solutions across federal, state, and local health landscapes."

**Pattern Elements**:
- Agency full name and acronym (first use)
- Specific initiative name (if applicable)
- Agency's goal or mission
- Agile Six's specific contribution
- Outcome or impact
- Present progressive for ongoing work ("is implementing")
- Past tense for completed work ("delivered")

**Source**: Agent 2 Voice/Tone Analysis, Agency Partnership Descriptions

## Writing Checklist

Before finalizing any copy, verify:

### Accuracy
- [ ] "Veteran" capitalized in all instances
- [ ] Military terms capitalized correctly
- [ ] Service member vs. Veteran used correctly
- [ ] Agency names capitalized on first reference
- [ ] Tagline punctuation correct (period, not comma)

### Brand Consistency
- [ ] Uses standard brand phrases where appropriate
- [ ] Aligns with voice/tone for material type
- [ ] Core values referenced accurately
- [ ] Company description matches boilerplate

### Clarity and Inclusivity
- [ ] People-first language used
- [ ] No jargon without explanation
- [ ] Inclusive and welcoming tone
- [ ] Clear and concise
- [ ] Appropriate for audience

### Grammar and Style
- [ ] Active voice preferred
- [ ] Contractions used naturally (recruiting/internal)
- [ ] Contractions avoided (formal client-facing)
- [ ] Sentence length varied
- [ ] Paragraph length appropriate for context

---

## See Also

- [Brand Essence](brand-essence.md) - Core values and brand story
- [Typography Guidelines](typography.md) - Tagline formatting
- [Imagery Guidelines](imagery-guidelines.md) - Alt text and captions
- [Boilerplate Text Library](../reference/boilerplate-text.md) - Exact text for copy-paste
- [Voice and Tone Examples](../examples/voice-tone-examples.md) - Real-world examples

---

**Version**: 1.0 | **Last Updated**: November 17, 2025 | **Sources**: AgileSix_styleguide_DRAFT5.pdf; Agent 2 Voice/Tone Analysis
