# Imagery Guidelines

**Version**: 1.0
**Last Updated**: November 17, 2025
**Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Pages 11-12

## Overview

Imagery is a powerful tool for communicating the Agile Six brand. All images should align with our people-first, inclusive values and accurately represent the communities we serve.

**Key Principle**: "Imagery should aim to tell a story. Images should always feel modern and be natural, not overly posed, showcasing our values and what makes Agile Six unique."

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 11]

## General Photography Guidelines

### Image Selection Criteria

**Style and Tone**:
- Modern, professional imagery
- Natural, authentic moments (not overly posed)
- People-focused photographs showcasing real people
- Images that reflect Agile Six values (wholeness, inclusion, purpose)
- Professional quality with good composition and lighting

**What to Look For**:
- Authentic expressions and interactions
- Diverse representation across all imagery
- People engaged in meaningful work
- Collaborative team environments
- Modern, clean visual aesthetic

**What to Avoid**:
- Overly staged or artificial-looking photos
- Stock photo cliches (exaggerated smiles, awkward handshakes)
- Images that do not reflect diversity and inclusion
- Dated or low-quality photography
- Images that contradict Agile Six values

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 11]

### Diversity and Inclusion Requirements

**Representation Matters**:
- Ensure diverse representation across all materials
- Show people of different races, ethnicities, ages, abilities, and genders
- Represent the full spectrum of the communities we serve
- Include images of people with visible and invisible disabilities
- Showcase Veterans and service members authentically

**Inclusive Imagery Principles**:
- Avoid tokenism (one diverse person among many)
- Show people in positions of leadership and expertise
- Represent people authentically in their professional contexts
- Avoid stereotypes or limiting representations

**Source**: Agile Six core values (Wholeness, Inclusion) and SDVOSB status

## Military and Veteran Imagery Guidelines

**CRITICAL IMPORTANCE**: As a Service-Disabled Veteran-Owned Small Business (SDVOSB), Agile Six must represent military and Veteran imagery with accuracy, respect, and domain expertise.

### Domain Experience Validation

**Recommendation**: "Military imagery should have domain experience validation recommended."

**Why This Matters**:
- Accuracy in military representations is critical for credibility
- Incorrect details are immediately apparent to military community
- Reflects on Agile Six's understanding and respect for military culture
- Essential for maintaining trust with Veteran employees and clients

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]

### Uniform Guidelines

#### Rank and Rate Insignia

**Rules**:
- Rank/rate insignia must be correctly placed on uniforms
- Different services have different rank structures and insignia
- Placement varies by service branch and uniform type
- When in doubt, consult with Veteran team members or military experts

**Critical Accuracy**:
- Army: Rank on chest and sleeves (depending on uniform)
- Navy: Rate on sleeve, rank on collar or shoulders
- Air Force: Rank on shoulders
- Marine Corps: Rank on collar or sleeves
- Coast Guard: Rank on shoulders or sleeves

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; Military uniform regulations

#### Flag Placement on Uniforms

**Rules**:
- American flag patches must be correctly oriented on uniforms
- Right shoulder: Flag appears "reversed" (star field toward front)
- Symbolism: Flag advancing into battle, not retreating
- Incorrect flag placement is a significant error

**Critical Detail**: "Proper flag placement on uniforms" is specifically called out in guidelines.

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; AR 670-1 (Army), equivalent regulations for other services

#### Facial Hair Restrictions

**Rules**: "Facial hair restrictions for uniformed personnel (must be clean-shaven in official photos)"

**Critical Guidelines**:
- Active duty personnel in uniform must be clean-shaven (except authorized religious/medical exceptions)
- Mustaches allowed within strict grooming standards (varies by service)
- Beards generally not permitted while in uniform (limited exceptions)
- Veterans out of uniform are not subject to these restrictions

**When This Applies**:
- ANY photo showing someone in military uniform
- Official military settings or ceremonies
- Formal military photography

**When This Does NOT Apply**:
- Veterans in civilian clothes
- Casual or off-duty photos (even if subject is active duty)
- Historical images where standards may have differed

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; Service grooming standards

### Respectful Representation

#### Prosthetics and Wheelchair Usage

**Guideline**: "Prosthetics/wheelchair usage: Show appropriately and respectfully"

**Key Principles**:
- Show assistive devices and adaptive equipment naturally and respectfully
- Avoid "inspiration porn" or overly focusing on disability
- Show Veterans with disabilities in professional, capable roles
- Include but don't make disability the defining characteristic
- Portray people with disabilities as active participants, not passive subjects

**Best Practices**:
- Show people using prosthetics and wheelchairs engaged in work
- Include in group photos without special emphasis
- Ensure photos show expertise and contribution, not just disability
- Avoid "overcoming" narratives that patronize

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; Disability representation best practices

#### National Guard vs. Veteran Distinctions

**Guideline**: "National Guard vs Veteran distinctions matter"

**Critical Distinctions**:
- **National Guard**: Part-time service members, may or may not be Veterans
- **Veteran**: Someone who has served and been discharged from military service
- **Active Duty**: Currently serving full-time
- **Reservist**: Part-time service, similar to National Guard

**Why This Matters**:
- Not all service members are Veterans (some still serving)
- National Guard members may not identify as Veterans if still serving
- Terminology accuracy matters in captions and descriptions
- Different benefits and experiences for different service statuses

**Correct Usage**:
- Use "service member" when current status unknown
- Use "Veteran" only for those who have completed service
- Use specific terms (Guard, Reserve, Active) when known
- When in doubt, ask or use general term "military community"

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]

### Context Understanding

**Image Context Matters**:
- **Combat imagery**: Appropriate for some contexts, not for others
- **Administrative/office work**: Represents majority of military jobs
- **Ceremonial imagery**: Formal events, change of command, retirements
- **Training imagery**: Shows preparation and skill development
- **Deployment**: Distinct from combat, shows service context

**Guideline**: "Context for military-specific imagery" - understand what the image represents and use appropriately.

**Best Practices**:
- Match image context to message (don't use combat images for administrative topics)
- Understand the setting and meaning of military imagery
- Avoid using military imagery purely for aesthetic without understanding
- Consider whether military imagery is necessary or if civilian imagery better serves message

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]

## Technical Specifications

### Resolution Requirements

**Print Materials**:
- **Minimum**: 300 DPI (dots per inch)
- **Recommended**: 300 DPI or higher for professional quality
- **Large format printing**: May require higher resolution

**Digital/Screen**:
- **Web**: 72-150 DPI acceptable
- **Presentations**: 150 DPI for best quality on screens
- **Social media**: Follow platform specifications

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 11]; Standard print specifications

### File Formats

**Preferred Formats**:
- **Print**: TIFF or high-quality JPEG (300 DPI)
- **Web**: JPEG or PNG (optimized for web)
- **Presentations**: JPEG or PNG (sufficient resolution)

**File Size Considerations**:
- Balance quality with file size for digital use
- Maintain original high-resolution files for future use
- Optimize for platform when possible

## Accessibility Requirements

### Alt Text for All Images

**Requirement**: "Alt text for accessibility"

**Best Practices**:
- Provide descriptive alternative text for all images
- Describe what's in the image, not just "image of person"
- Include relevant context (setting, activity, significance)
- Keep alt text concise but informative (1-2 sentences)

**Examples**:

Good Alt Text:
- "Three Agile Six team members collaborating on laptops in a modern office setting"
- "Veteran software engineer reviewing code on multiple monitors"
- "Service member in Army uniform presenting at a whiteboard to colleagues"

Poor Alt Text:
- "Image"
- "Photo of people"
- "Team meeting"

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; WCAG 2.1 AA requirements

### Context Description for Military Imagery

**Special Requirement for Military Photos**:
- Describe service branch if visible
- Note rank/role if relevant to context
- Describe setting (office, field, ceremony, etc.)
- Include disability/adaptive equipment naturally in description

**Example**:
"Navy Veteran using a prosthetic leg stands at a standing desk while coding on dual monitors in a modern office"

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; Accessibility best practices

## Photography Sourcing

### Stock Photo Resources

**When Using Stock Photography**:
- Prefer authentic Veteran photography when possible
- Verify military imagery accuracy before use
- Ensure diversity in stock photo selection
- Avoid overused or cliche stock images

**Recommended Approach**:
- Use real Agile Six employee photos when possible
- For stock photos, prioritize authentic-looking imagery
- Have Veteran team members review military imagery
- Source from diverse, inclusive stock photo libraries

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 12]; Best practices

### Authentic Agile Six Photography

**Preference**: Use photos of actual Agile Six employees and projects when possible

**Benefits**:
- Authentic representation of our team
- Natural diversity of our workforce
- Real examples of our work environment
- Builds trust and authenticity
- Showcases our remote-first culture

**Considerations**:
- Obtain permission from employees
- Ensure professional quality
- Respect privacy preferences
- Update regularly to stay current

## Image Usage Checklist

Before using any image, verify:

- [ ] Image is modern, professional, and natural (not overly posed)
- [ ] Represents diversity and inclusion appropriately
- [ ] High enough resolution for intended use (300 DPI for print)
- [ ] Proper file format for platform
- [ ] Alt text provided for accessibility
- [ ] **If military imagery**: Uniform details accurate
- [ ] **If military imagery**: Rank/rate insignia correct
- [ ] **If military imagery**: Flag placement correct (if visible)
- [ ] **If military imagery**: Grooming standards met (clean-shaven in uniform)
- [ ] **If military imagery**: Context appropriate for message
- [ ] **If military imagery**: Veteran vs. service member terminology correct
- [ ] **If showing disability**: Represented respectfully and naturally
- [ ] Permission/licensing secured for image use
- [ ] Image aligns with Agile Six values and brand

## Common Mistakes to Avoid

### Military Imagery Errors

1. **Incorrect uniform details** - Always validate with domain experts
2. **Using combat imagery inappropriately** - Understand context
3. **Calling all service members "Veterans"** - Not all are
4. **Showing bearded personnel in uniform** - Violates grooming standards (except authorized exceptions)
5. **Backward or incorrectly placed flags** - Major error
6. **Mixed uniform items** - Don't combine different service uniforms

### General Imagery Errors

1. **Lack of diversity** - Every collection should represent our full team
2. **Tokenism** - One diverse person in otherwise homogeneous group
3. **Low resolution images** - Won't print well or look professional
4. **Missing alt text** - Accessibility requirement
5. **Overly staged photos** - Appears inauthentic
6. **Stereotypical representations** - Avoid cliches and limiting portrayals

## When to Consult Experts

**Consult with Veteran team members or experts when**:
- Using military imagery you're unfamiliar with
- Uncertain about uniform accuracy
- Need to understand military context
- Writing captions or descriptions for military images
- Selecting images for Veteran-focused communications

**Domain expertise is critical** for maintaining credibility and respect.

---

## See Also

- [Brand Essence](brand-essence.md) - Agile Six values that guide imagery selection
- [Copywriting Guidelines](copywriting-guidelines.md) - Terminology for image captions
- [Accessibility Standards](accessibility-standards.md) - Alt text and WCAG requirements
- [Print Specifications](print-specifications.md) - Technical requirements for print imagery

---

**Version**: 1.0 | **Last Updated**: November 17, 2025 | **Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Pages 11-12
