# Agile Six Logo Usage Guidelines

## Available Logo Variations

According to the Agile Six brand guidelines, there are **4 total logo variations**, plus a reversed (white) version:

### 1. Preferred Standalone Logo (Navy) ✅ Available
- **File**: `assets/logos/agile6_logo_rgb_large.png`
- **Description**: "agilesix" wordmark only, navy color
- **Format**: PNG with transparency
- **Dimensions**: High resolution, scalable
- **Usage**: Primary logo for light backgrounds
- **Best for**:
  - White or light grey backgrounds
  - Content sections
  - Official documents on light backgrounds
  - Website and digital applications
- **Background compatibility**: White, light grey, light backgrounds only

### 2. Reversed Standalone Logo (White) ✅ Available
- **File**: `assets/logos/agile6_logo_rev_large.png`
- **Description**: "agilesix" wordmark only, white color
- **Format**: PNG with transparency
- **Dimensions**: High resolution, scalable
- **Usage**: Logo for dark backgrounds - **CRITICAL FOR PROPER CONTRAST**
- **Best for**:
  - Navy (#003A70) backgrounds
  - Dark backgrounds
  - Title sections with navy backgrounds
  - Closing sections with navy backgrounds
- **Background compatibility**: Navy, dark backgrounds only
- **⚠️ IMPORTANT**: Always use this white logo on navy backgrounds - never use the navy logo on navy (fails contrast requirements)

### 3. Logo with Tagline ✅ Available
- **Description**: "agilesix" wordmark with tagline on right, separated by vertical line
- **Tagline**: "A better place to work. Better work to do."
- **Layout**: Logo | Tagline (two lines of text)
- **Minimum Size**: 1.75 inches
- **Usage**: Marketing materials, recruiting documents, materials where brand message reinforcement is important
- **Best for**:
  - External materials
  - Marketing collateral
  - Brand-focused communications
  - Recruiting materials
  - Closing sections when brand message is key

**Available variants**:
- **Navy/Color** (light backgrounds): `assets/logos/with-tagline/color/agile6_logo_tag_rgb_large.png`
- **Black** (grayscale): `assets/logos/with-tagline/black/agile6_logo_tag_k_large.png`
- **White/Reversed** (dark backgrounds): `assets/logos/with-tagline/white/agile6_logo_tag_rev_large.png`

### 4. Alternate Logo with Prominent Tagline ✅ Available
- **Description**: "agilesix" wordmark with larger, more prominent tagline
- **Tagline**: "A better place to work. Better work to do." (larger and more visible)
- **Minimum Size**: 1.75 inches
- **Usage**: "To be used as needed when tagline needs to be large and highly visible"
- **Best for**:
  - Brand-centric materials
  - Events and conferences
  - Marketing materials where messaging is paramount
  - Brand campaigns emphasizing mission and values
  - When tagline requires emphasis

**Available variants**:
- **Navy/Color** (light backgrounds): `assets/logos/alt-logo/color/agile6_logo_alt_rgb_large.png`
- **Black** (grayscale): `assets/logos/alt-logo/black/agile6_logo_alt_k.png`
- **White/Reversed** (dark backgrounds): `assets/logos/alt-logo/white/agile6_logo_alt_rev_large.png`

### 5. Social Media Icon ✅ Available
- **File**: `assets/logos/agile6_social_icon_500x500.jpg`
- **Description**: Lowercase letter "a" in white on navy background with light blue accent bar
- **Format**: JPG, square format
- **Dimensions**: 500x500px
- **Design elements**:
  - Navy (#003A70) background
  - White lowercase "a" (large, centered)
  - Light blue (#41B6E6) horizontal bar at bottom (~15% of height)
- **Usage**: Social media profiles, avatars, small icons, favicons
- **Best for**:
  - Social media profile images
  - Small footer icons
  - App icons
  - Digital avatars
- **Not for**: Primary branding in materials (use standalone logo instead)

## Logo Usage Rules

### Clear Space Requirements

Maintain clear space around the logo equal to the **height of the lowercase "a"** in "agilesix".

```
┌─────────────────────────────────┐
│                                 │
│   ┌───────────────────┐        │
│   │                   │        │ ← Clear space = height of "a"
│   │   agilesix        │        │
│   │                   │        │
│   └───────────────────┘        │
│                                 │
└─────────────────────────────────┘
```

**Rules**:
- No text, graphics, or other elements within clear space
- Maintain clear space on all four sides
- Clear space ensures logo visibility and impact

### Minimum Size Requirements

To ensure legibility and professionalism:

**Print Applications**:
- Minimum width: 0.5 inches
- Smaller sizes compromise legibility

**Digital Applications**:
- Minimum width: 100 pixels
- Social media icon: 180x180px minimum

**Digital Materials**:
- Primary elements: Minimum 1 inch wide (ideal: 2-3 inches)
- Headers/footers (small logo): Minimum 0.75 inches wide
- Closing elements: Minimum 1.5 inches wide

### Background Color Guidelines

#### ✅ Approved Backgrounds

1. **White (#FFFFFF)**
   - Use: Standard navy logo
   - Best for: Most applications, high contrast

2. **Light Grey (#D9D9D6)**
   - Use: Standard navy logo
   - Best for: Alternate section backgrounds, subtle variation

3. **Navy (#003A70)**
   - Use: Reversed/white version of logo (if available)
   - Best for: Primary sections, section dividers, brand-heavy applications
   - Note: If reversed logo not available, use logo on white overlay or different background

#### ⚠️ Use with Caution

- **Photographic backgrounds**: Only if high contrast area available
- **Patterned backgrounds**: Only if pattern is subtle and non-competing
- **Colored backgrounds**: Only use brand colors listed above

#### ❌ Avoid

- Busy or cluttered backgrounds that compete with logo
- Low contrast backgrounds (light blue, light grey on white, etc.)
- Non-brand colored backgrounds
- Gradients behind the logo (place on solid area)
- Shadows or effects that obscure logo

## Logo Placement Guidelines

### Primary Title Sections

**Option 1: Centered Placement**
- Position: Center of page/screen, typically lower third
- Size: Large (2-3 inches wide)
- Version: Standalone logo or logo with tagline
- Background: Navy background with white logo, or white background with navy logo
- Impact: Strong brand presence

**Option 2: Upper-Left Placement**
- Position: Upper-left corner with appropriate margins
- Size: Medium (1.5-2 inches wide)
- Version: Standalone logo only
- Background: Any approved background
- Impact: Professional, corporate feel

### Body Content Sections

**Option 1: Upper-Left Corner**
- Position: Consistent placement, typically 0.5" from top and left edges
- Size: Small (0.75-1 inch wide)
- Version: Standalone logo only
- Purpose: Subtle brand presence, doesn't compete with content

**Option 2: Footer Area**
- Position: Lower-left or lower-right corner
- Size: Small (0.75-1 inch wide)
- Version: Standalone logo only
- Purpose: Consistent branding throughout document

**Best Practice**: Choose one placement strategy and maintain consistency throughout material

### Closing Sections

**Centered with Tagline**
- Position: Center of page/screen
- Size: Large (2+ inches wide)
- Version: Logo with tagline (if available) or standalone
- Background: Navy or white
- Purpose: Reinforce brand and leave strong impression

### Headers and Footers

- **Size**: 0.5-0.75 inches wide
- **Position**: Consistent placement (typically left side)
- **Version**: Standalone logo only
- **Usage**: Page headers, document footers, recurring branding elements

## Logo Usage Don'ts

### ❌ Never Do These Things

1. **Don't stretch or distort the logo**
   - Maintain original aspect ratio
   - Lock proportions when resizing
   - Distortion damages brand credibility

2. **Don't change logo colors**
   - Use only official navy (#003A70) or reversed white version
   - Don't apply other brand colors to logo
   - Don't use gradient or multi-color effects

3. **Don't add effects**
   - No drop shadows
   - No glows or outer glows
   - No gradients
   - No 3D effects or bevels
   - No transparency/opacity changes

4. **Don't rotate the logo**
   - Logo must always be horizontal
   - No angled or vertical orientations
   - Maintain level, straight placement

5. **Don't recreate the logo with system fonts**
   - Logo typography is custom and proprietary
   - Never type "agilesix" as a substitute for logo
   - Always use official logo files

6. **Don't place on low-contrast backgrounds**
   - Ensure sufficient contrast for visibility
   - Navy logo requires light background
   - White logo requires dark background

7. **Don't remove or modify elements**
   - Use complete logo as provided
   - Don't remove dots above letters
   - Don't modify letter spacing or forms
   - Don't add additional elements to logo

8. **Don't use as a decorative pattern**
   - Logo is brand identifier, not decoration
   - Use sparingly and intentionally
   - Overuse diminishes impact

## Accessibility Considerations

### Alt Text Requirements

Always provide descriptive alt text for screen readers:

**Standalone logo**:
- Alt text: "Agile Six logo"

**Logo with tagline**:
- Alt text: "Agile Six logo with tagline: A better place to work. Better work to do."

**Social media icon**:
- Alt text: "Agile Six icon" or "Agile Six"

### Visibility and Contrast

- Ensure logo has sufficient contrast with background (4.5:1 minimum)
- Navy logo on white meets this requirement (12.6:1)
- Test visibility in different contexts (projector, print, screens)

### Don't Overuse

- Logo should not appear on every single page/section (screen reader fatigue)
- Consider: Opening section, closing section, and optional small logo on content pages
- Logo is not required on every page for brand recognition

## Special Use Cases

### Small-Scale Applications

When logo must be very small (business cards, email signatures):
- Use simplified version if available (social media icon)
- Ensure minimum size requirements are met
- Test legibility at actual size before finalizing

### Monochrome/Black & White

When color is not available:
- Use navy logo on white (appears as dark/black)
- Ensure sufficient contrast in grayscale
- Avoid printing on grey backgrounds in black and white

### Digital vs. Print

**Digital**:
- Use RGB color profile
- PNG format with transparency preferred
- Ensure adequate resolution (minimum 100px wide)

**Print**:
- Use CMYK color profile when available
- High-resolution files (300 DPI minimum)
- Vector formats preferred for scalability

## Logo File Management

### Current Available Files

Located in: `.claude/skills/agile-six-brand/assets/logos/` (10 files, hierarchically organized)

**Standard Logo** (3 files):
1. `standard/color/agile6_logo_rgb_large.png` - Navy for light backgrounds
2. `standard/black/agile6_logo_k_large.png` - Black for grayscale
3. `standard/white/agile6_logo_rev_large.png` - White for dark backgrounds

**Logo with Tagline** (3 files):
4. `with-tagline/color/agile6_logo_tag_rgb_large.png` - Navy for light backgrounds
5. `with-tagline/black/agile6_logo_tag_k_large.png` - Black for grayscale
6. `with-tagline/white/agile6_logo_tag_rev_large.png` - White for dark backgrounds

**Alt Logo with Prominent Tagline** (3 files):
7. `alt-logo/color/agile6_logo_alt_rgb_large.png` - Navy for light backgrounds
8. `alt-logo/black/agile6_logo_alt_k.png` - Black for grayscale
9. `alt-logo/white/agile6_logo_alt_rev_large.png` - White for dark backgrounds

**Social Media Icon** (1 file):
10. `social-icon/agile6_social_icon_500x500.jpg` - Social media profile pictures

### File Format Guidance

**PNG (Preferred for digital)**:
- Supports transparency
- Lossless compression
- Best for: Digital materials, web, documents

**JPG** (social icon only):
- Smaller file size
- No transparency
- Best for: Photos, social media where transparency not needed

**Vector formats** (SVG, AI, EPS):
- Infinitely scalable
- Best for: Print, large-scale applications
- Status: Not currently included in skill assets

## Additional Logo Formats

The skill includes 10 PNG and JPG files optimized for digital use. For additional formats or files not included:

1. **Vector files (EPS, SVG, AI)**:
   - Complete A6_Branding_Materials package contains vector versions
   - Best for: Print production, large-scale applications
   - Contact: Brand/marketing team

2. **Print-specific formats (CMYK, PMS654)**:
   - Vector files with CMYK and Pantone color profiles
   - Best for: Professional printing
   - Contact: Brand/marketing team

3. **Different resolutions or dimensions**:
   - Complete materials package has 51 total files
   - Reference: Working docs Agent 3 Asset Organization Report
   - Contact: Brand/marketing team

## Quick Reference Checklist

Before using the Agile Six logo:

- ✓ Using official logo files (not recreating with fonts)
- ✓ Maintaining clear space around logo
- ✓ Logo is minimum required size
- ✓ Placed on approved background color
- ✓ Not stretched, distorted, or rotated
- ✓ No effects or modifications applied
- ✓ Sufficient contrast with background
- ✓ Alt text provided for accessibility
- ✓ Appropriate version for context (standalone vs. with tagline)
- ✓ Consistent placement throughout project
