# Print Specifications

**Version**: 1.0
**Last Updated**: November 17, 2025
**Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Pages 7, 9-10

## Overview

Professional print materials require specific technical specifications to ensure accurate color reproduction and brand consistency. This guide covers color systems, file formats, and resolution requirements for Agile Six print projects.

## Color Systems for Print

### Pantone (PMS) vs. CMYK

Agile Six brand colors are specified in three color systems:
- **Pantone (PMS)** - Spot color for brand-critical printing
- **CMYK** - 4-color process for full-color printing
- **RGB/HEX** - Digital/screen display (not for print)

### Pantone Matching System (PMS)

**Definition**: "The listed PMS colors will render the most accurate printing of the brand colors. This type of printing uses a standardized ink formula that allows for consistency across the world. This is best for 1 or 2-color jobs."

**How PMS Works**:
- Uses pre-mixed spot color inks
- Each PMS color has a unique number (e.g., PMS 654)
- Standardized formulas ensure consistency worldwide
- Most accurate color reproduction
- More expensive than CMYK for multi-color jobs

**When to Use PMS**:
- Logo printing (brand-critical accuracy)
- Brand color matching requirements
- 1-2 color print jobs
- Business cards, letterhead, envelopes
- Signage and branded items
- When exact color match is essential

**Agile Six PMS Colors**:
- **Blue (Navy)**: PMS 654
- **Dark Grey**: PMS 424
- **Cyan**: PMS 298
- **Dark Cyan**: PMS 7461
- **Red**: PMS 7623
- **Light Gray**: PMS Cool Grey 1
- **Light Blue**: PMS 650

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

### CMYK (4-Color Process)

**Definition**: "For four-color process reproduction, the CMYK builds that are shown are those that best match the Pantone colors. This is best for brochures, flyers, and marketing collateral."

**How CMYK Works**:
- Uses four ink colors: Cyan, Magenta, Yellow, Black (Key)
- Colors created by combining different percentages of each ink
- More economical for multi-color printing
- Less precise than PMS but suitable for most applications

**When to Use CMYK**:
- Full-color brochures and flyers
- Marketing materials with photography
- Multi-page documents
- Cost-sensitive projects
- Any print job with more than 2-3 colors
- Publications and magazines

**Agile Six CMYK Builds**:
- **Blue (Navy)**: 100 / 71 / 10 / 47
- **Dark Grey**: 30 / 20 / 19 / 58
- **Cyan**: 67 / 2 / 0 / 0
- **Dark Cyan**: 100 / 34 / 0 / 27
- **Red**: 0 / 97 / 87 / 53
- **Light Gray**: 4 / 2 / 4 / 8
- **Light Blue**: 17 / 6 / 3 / 0

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

### Choosing Between PMS and CMYK

| Consideration | PMS (Spot Color) | CMYK (Process) |
|---------------|------------------|----------------|
| **Color Accuracy** | Exact match to Pantone standard | Approximation of color |
| **Best For** | 1-2 color jobs | Multi-color jobs |
| **Cost** | More expensive per color | More economical overall |
| **Use Cases** | Logo, brand items, signage | Brochures, full-color materials |
| **Consistency** | Worldwide standard | May vary between printers |
| **Photography** | Not suitable | Excellent |

**General Rule**:
- **Logo only or brand-critical**: Use PMS
- **Photos or full-color**: Use CMYK
- **Both needed**: Print logo in PMS, photos in CMYK (hybrid job)

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]; Print production best practices

## Resolution Requirements

### Digital vs. Print Resolution

**Print Materials**:
- **Minimum**: 300 DPI (dots per inch)
- **Recommended**: 300 DPI or higher
- **Large format**: May require higher resolution (check with printer)

**Why 300 DPI**:
- Standard professional print quality
- Below 300 DPI will appear pixelated or blurry when printed
- Digital images (72-150 DPI) are NOT print-ready

**Digital/Screen Materials**:
- **Web**: 72-150 DPI acceptable
- **Presentations**: 150 DPI recommended for screen display
- **Do NOT use for print**

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 11]; Print industry standards

### Checking Image Resolution

**Before Sending to Print**:
1. Open image in photo editing software
2. Check image properties (should show DPI)
3. Verify physical size at 300 DPI
   - Formula: Pixel width ÷ 300 = Print width in inches
   - Example: 3000px wide ÷ 300 DPI = 10 inches wide print
4. If resolution too low, use smaller print size or higher resolution image

**Common Issues**:
- Screenshot images: Usually only 72-150 DPI (not print-ready)
- Web images: Often low resolution (not suitable for print)
- Phone photos: May be high resolution but check actual DPI

**Source**: Print production best practices

## File Formats for Print

### Vector Formats (Preferred for Logos)

**EPS (Encapsulated PostScript)**:
- ✅ **Best for**: Logos, illustrations, vector graphics
- **Advantages**: Infinitely scalable, no resolution loss
- **Usage**: All Agile Six logos available in EPS format
- **Variants**: CMYK and PMS versions available

**PDF (Portable Document Format)**:
- ✅ **Best for**: Complete documents, multi-page layouts
- **Advantages**: Preserves fonts, colors, and layout
- **Usage**: Final print-ready documents
- **Requirements**: PDF/X-1a or PDF/X-4 for professional printing

**AI (Adobe Illustrator)**:
- **Best for**: Editable vector graphics
- **Usage**: Source files for design work
- **For Print**: Export to EPS or PDF

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Pages 7-10]; Print specifications

### Raster Formats (For Photography)

**TIFF (Tagged Image File Format)**:
- ✅ **Best for**: High-quality photographs for print
- **Requirements**: 300 DPI, CMYK color mode
- **Advantages**: Lossless compression, industry standard
- **File Size**: Large (high quality)

**JPEG (Joint Photographic Experts Group)**:
- ✅ **Acceptable for**: Photos when file size matters
- **Requirements**: 300 DPI, highest quality setting
- **Caution**: Lossy compression (some quality loss)
- **Usage**: When TIFF file size prohibitive

**PNG (Portable Network Graphics)**:
- **Best for**: Digital/web use (not ideal for print)
- **Acceptable for**: Print if 300 DPI and high quality
- **Advantages**: Supports transparency
- **Usage**: Logo files (high-res PNG available)

**Source**: Print file format standards

### File Format Decision Tree

```
Is it a logo or vector graphic?
  → YES: Use EPS (vector) or high-res PNG (if vector not available)

Is it a photograph or raster image?
  → YES: Use TIFF (best) or high-quality JPEG (300 DPI)

Is it a complete multi-page document?
  → YES: Use PDF (PDF/X-1a or PDF/X-4 standard)

Do you need to edit it?
  → YES: Use native format (AI, PSD) then export for print
```

## Logo Files for Print

### Available Logo Formats

**All Agile Six logos available in**:
- EPS (CMYK) - 4-color process printing
- EPS (PMS) - Spot color printing
- High-resolution PNG (RGB) - Digital use or fallback
- Standard PNG (RGB) - Digital use only

**File Naming Convention**:
```
{logo-type}_{variant}_{color-mode}.{extension}

Examples:
- agile6_logo_cmyk.eps (standard logo, CMYK)
- agile6_logo_PMS.eps (standard logo, Pantone)
- agile6_logo_tag_cmyk.eps (logo with tagline, CMYK)
- agile6_logo_rev.eps (reversed/white logo)
```

**Source**: [Logo file organization, Agent 3 Asset Analysis]

### Selecting Logo Files for Print

**For Spot Color Printing (PMS)**:
- Use: `agile6_logo_PMS.eps`
- Color: PMS 654 (navy)
- When: Logo-only materials, business cards, letterhead

**For 4-Color Process Printing (CMYK)**:
- Use: `agile6_logo_cmyk.eps`
- Color: CMYK build (100/71/10/47)
- When: Brochures, flyers, full-color materials

**For White/Reversed Logo**:
- Use: `agile6_logo_rev.eps`
- Color: White (knockout)
- When: Dark backgrounds, navy backgrounds

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 9]; [Logo Usage Guidelines](logo-usage.md)

## Typography for Print

### Print-Specific Font Specifications

**Primary Font**: Nexa

**Guideline**: "To maintain consistency in our graphic identity, it is recommended that print layout copy be set in the Nexa typeface."

**Available Weights**:
- Nexa Book / Book Italic
- Nexa Regular / Regular Italic
- Nexa Bold / Bold Italic
- Nexa Extra Bold / Extra Bold Italic

**When Nexa Not Available**: "When Nexa is not available, Arial may be substituted for the official typeface."

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 10]

### Font Embedding in PDFs

**For Print PDFs**:
- Always embed fonts in PDF
- Use PDF/X-1a standard (embeds all fonts automatically)
- Verify fonts embedded before sending to printer
- Convert text to outlines as last resort (loses editability)

**Checking Font Embedding**:
1. Open PDF in Adobe Acrobat
2. File → Properties → Fonts
3. All fonts should show "(Embedded)" or "(Embedded Subset)"

**Source**: Print production best practices

## Print Production Workflow

### 1. Design Phase

**Color Mode**:
- Design in CMYK mode (not RGB)
- Use Agile Six CMYK builds
- Preview color accuracy

**Resolution**:
- Place images at 300 DPI minimum
- Check image quality at 100% view
- Don't scale up low-resolution images

**Fonts**:
- Use Nexa (if licensed) or Arial
- Embed fonts in final PDF
- Minimum 8pt font size for readability

**Source**: Print design best practices

### 2. Pre-Flight Check

**Before Sending to Print**:
- [ ] Color mode is CMYK (or specified PMS colors)
- [ ] All images 300 DPI or higher
- [ ] Fonts embedded in PDF
- [ ] Logo files are vector (EPS) or high-res
- [ ] Bleeds added if needed (0.125" standard)
- [ ] Crop marks and printer's marks included (if requested)
- [ ] Black text is 100% K (not CMYK build)
- [ ] No RGB images or colors
- [ ] File named clearly and correctly

**Source**: Print pre-flight checklist

### 3. Proofing

**Soft Proof** (On Screen):
- View in Adobe Acrobat
- Enable "Simulate Paper Color"
- Check colors appear correct
- Review at 100% and zoomed in

**Hard Proof** (Physical Sample):
- Request proof from printer for critical jobs
- Review colors, registration, quality
- Approve or request corrections
- Keep approved proof for reference

**Source**: Print proofing procedures

### 4. Print Specifications to Provide

**When Requesting Print Quote**:
- Quantity needed
- Paper size and type
- Color: CMYK, PMS (specify numbers), or both
- Finishing: fold, bind, cut, etc.
- Turnaround time needed
- Provide print-ready PDF

**Source**: Print vendor communication guidelines

## Color Accuracy and Disclaimer

### Color Variation

**Official Statement**: "Color will vary from printer to printer and monitor to monitor. The only way to ensure accurate reproduction is to use a professional printer and have the printer print using Pantone inks."

**Why Color Varies**:
- Monitor calibration differences
- Printer capabilities and settings
- Paper type and coating
- Environmental factors (temperature, humidity)
- Ink/toner variations

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

### Pantone Accuracy Disclaimer

**Official Statement**: "The colors shown throughout this manual have not been evaluated by Pantone, Inc., for accuracy and may not match the PANTONE Color Standards. Please refer to the current edition of the Pantone color formula guide. PANTONE is a registered trademark of Pantone, Inc."

**Best Practice**:
- Use physical Pantone swatch book for color matching
- Provide PMS numbers to printer
- Request Pantone ink for critical color matching
- Approve printed proof before full run

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 7]

## Common Print Mistakes to Avoid

### Color Mode Errors
- ❌ Designing in RGB mode (will shift colors when converted to CMYK)
- ❌ Using RGB images in print document
- ❌ Not specifying PMS or CMYK to printer

### Resolution Errors
- ❌ Using low-resolution images (< 300 DPI)
- ❌ Scaling up images beyond their native resolution
- ❌ Using screenshots without checking resolution

### Font Errors
- ❌ Not embedding fonts in PDF
- ❌ Using fonts not licensed for commercial printing
- ❌ Font sizes too small to print clearly (< 8pt)

### File Format Errors
- ❌ Sending RGB PNG for print (should be CMYK TIFF or EPS)
- ❌ Using low-quality JPEG compression
- ❌ Not providing bleeds when needed
- ❌ Wrong PDF type (use PDF/X-1a for print)

### Logo Errors
- ❌ Using low-resolution PNG logo when EPS available
- ❌ Recreating logo with fonts (use official files)
- ❌ Using RGB logo version for CMYK printing
- ❌ Scaling logo below minimum size

**Source**: Common print production errors

## Print Vendor Communication

### Information to Provide Your Printer

**Essential Information**:
1. **Quantity**: How many needed
2. **Paper**: Size, weight, finish (coated, uncoated, etc.)
3. **Colors**: CMYK 4-color process, or specific PMS numbers
4. **Sides**: Single-sided or double-sided
5. **Finishing**: Folding, binding, cutting, etc.
6. **Timeline**: When do you need it completed
7. **Files**: Provide print-ready PDF

**Example Specification**:
"1000 business cards, 3.5" x 2", 16pt cardstock with matte finish, printed 4-color CMYK front and back, no special finishing. Need by [date]."

**Source**: Print production communication

### Questions to Ask Your Printer

- What file format do you prefer? (usually PDF/X-1a)
- Do you need bleeds? (usually 0.125")
- What resolution for images? (usually 300 DPI)
- Can you match PMS colors exactly?
- Can I see a proof before printing full run?
- What's the turnaround time?
- Do you offer design review or pre-flight check?

**Source**: Print vendor best practices

---

## See Also

- [Color Palette](colors.md) - Complete CMYK and PMS specifications
- [Typography Guidelines](typography.md) - Nexa font specifications
- [Logo Usage](logo-usage.md) - Logo file selection and sizing
- [Accessibility Standards](accessibility-standards.md) - Accessible print materials

---

**Version**: 1.0 | **Last Updated**: November 17, 2025 | **Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Pages 7, 9-10
