# Agile Six Typography Guidelines

**Version**: 2.0
**Last Updated**: November 17, 2025
**Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Page 10

## Overview

Agile Six typography is based on the Nexa typeface family for print materials, with specific alternates for digital and web use.

## Primary Font Family

### Nexa (Official Brand Font)

**Font Name**: Nexa

**Usage Guideline**: "To maintain consistency in our graphic identity, it is recommended that print layout copy be set in the Nexa typeface."

**Available Weights**:
- Nexa Book
- Nexa Book Italic
- Nexa Regular
- Nexa Regular Italic
- Nexa Bold
- Nexa Bold Italic
- Nexa Extra Bold
- Nexa Extra Bold Italic

**Character Set**: "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz 0123456789" (Nexa Extra Bold Characters shown)

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 10]

**Note**: Nexa may require licensing. Verify availability before use. If Nexa is not available, use the official alternate font hierarchy below.

## Alternate Font Hierarchy

### Print Alternate

**Arial** - Official Alternate

"When Nexa is not available, Arial may be substituted for the official typeface."

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 10]

**Usage**:
- Print materials when Nexa is not licensed
- Documents requiring universal compatibility
- Microsoft Office documents

**Weights to use**:
- Arial Regular for body text
- Arial Bold for headers
- Arial Black for extra bold emphasis

### Web/Digital Alternates

**For Website Design**: "For website design, a font similar to Nexa should be selected."

**Source**: [AgileSix_styleguide_DRAFT5.pdf, Page 10]

**Recommended Nexa-Similar Fonts for Digital** (in order of preference):

#### 1. Montserrat (Best Web Choice)
- **Style**: Geometric sans-serif
- **Why**: Very similar to Nexa aesthetic, widely available, excellent readability
- **Weights**: Use Regular (400) for body, Bold (700) for headers, ExtraBold (800) for display
- **Availability**: Google Fonts, free and widely supported
- **Best for**: Websites, digital materials, all screen-based applications
- **License**: Open Font License (free to use)

#### 2. Raleway
- **Style**: Elegant geometric sans-serif
- **Why**: Clean, modern, similar geometric construction to Nexa
- **Weights**: Use Regular (400) for body, Bold (700) for headers
- **Availability**: Google Fonts, widely available
- **Best for**: Professional materials, formal digital contexts
- **License**: Open Font License (free to use)

#### 3. Gotham (Premium Option)
- **Style**: Geometric sans-serif, professional
- **Why**: Geometric aesthetic very close to Nexa, premium quality
- **Weights**: Use Book or Regular for body, Bold for headers
- **Availability**: Commercial font (requires license)
- **Best for**: High-profile external materials, brand-critical content (if licensed)

### Digital/Office Fallback

#### Calibri (Universal Office Fallback)
- **Why**: Clean, modern, available on all Microsoft Office installations
- **Usage**: Suitable fallback for digital and Office documents
- **Weights**: Regular for body, Bold for headers
- **When to use**: When Nexa, Montserrat, or other preferred fonts unavailable

## Logo Typography

The Agile Six logo uses a **custom lowercase geometric sans-serif** typeface that is proprietary to the brand.

### Logo Type Characteristics

- **Style**: Geometric sans-serif
- **Case**: All lowercase letters
- **Design**: Custom, proprietary design
- **Key features**:
  - Geometric construction with circular forms
  - Rounded, friendly aesthetic
  - Modern and clean
  - Distinctive lowercase 'g' with circular counter
  - Two dots above the 'i' characters for visual interest

**⚠️ Important**: The logo typography is embedded in logo files and is NOT available as a system font. Do not attempt to recreate the logo text using substitute fonts.

## Typography Hierarchy

### Title Sections

**Main Title**
- **Font size**: 44pt minimum
- **Weight**: Bold (700)
- **Color**: White on navy background, or Navy on white background
- **Line height**: 1.2x
- **Alignment**: Center or left

**Subtitle**
- **Font size**: 28pt
- **Weight**: Regular (400) or Light (300)
- **Color**: White on navy, Light Blue on navy, or Dark Grey on white
- **Line height**: 1.3x
- **Alignment**: Match title alignment

### Content Sections

**Section Header**
- **Font size**: 32pt minimum
- **Weight**: Bold (700)
- **Color**: Navy (#003A70)
- **Line height**: 1.2x
- **Alignment**: Left

**Body Text**
- **Font size**: 18pt minimum (508 compliance requirement)
- **Weight**: Regular (400)
- **Color**: Dark Grey (#707372) or Navy (#003A70)
- **Line height**: 1.5x (improved readability)
- **Alignment**: Left

**Bullet Points**
- **Font size**: 18-20pt
- **Weight**: Regular (400)
- **Color**: Dark Grey (#707372)
- **Line height**: 1.5x
- **Bullet style**: Simple round bullets in Navy or Light Blue

**Captions / Notes**
- **Font size**: 14pt minimum (only if bold weight)
- **Weight**: Bold (700) if 14pt, Regular if 16pt+
- **Color**: Dark Grey (#707372)
- **Line height**: 1.4x
- **Usage**: Image captions, footnotes, disclaimers

### Section Dividers

**Section Title**
- **Font size**: 48-54pt
- **Weight**: Bold (700)
- **Color**: White on colored background
- **Line height**: 1.2x
- **Alignment**: Center

### Data Visualizations / Charts

**Chart Title**
- **Font size**: 24-28pt
- **Weight**: Bold (700)
- **Color**: Navy (#003A70)

**Axis Labels**
- **Font size**: 16-18pt
- **Weight**: Regular (400)
- **Color**: Dark Grey (#707372)

**Data Labels**
- **Font size**: 14-16pt (bold if 14pt)
- **Weight**: Bold (700) if small, Regular if larger
- **Color**: Dark Grey (#707372) or Navy (#003A70)

**Legend Text**
- **Font size**: 14-16pt
- **Weight**: Regular (400)
- **Color**: Dark Grey (#707372)

## Accessibility Requirements (508 Compliance)

### Minimum Font Sizes

- **Body text**: 18pt minimum (all contexts)
- **Headings**: 24pt minimum
- **Small text**: 14pt ONLY if bold weight (700+)
- **Chart labels**: 14pt minimum (preferably bold)

### Font Weight Guidelines

- **Below 20pt**: Use regular (400) or bold (700) weights only
- **Avoid light weights** (<300) for text smaller than 24pt
- **Thin/Light fonts**: Only use for large display text (36pt+)

### Line Spacing (Leading)

- **Body text**: 1.5x font size minimum
- **Headings**: 1.2-1.3x font size
- **Tight spacing**: Avoid for accessibility (hard to read)

### Letter Spacing (Tracking)

- **Default**: Use font's default letter spacing
- **All caps**: Increase tracking slightly (+5-10%) for readability
- **Avoid**: Tight tracking (negative values) for small text

## Typography Best Practices

### ✅ Do This

- Use geometric sans-serif fonts that complement the brand
- Maintain strong hierarchy with size and weight differences
- Ensure all text meets 508 minimum sizes (18pt body, 14pt bold minimum)
- Use bold weights for emphasis rather than color alone
- Keep line lengths readable (maximum 50-75 characters per line)
- Use consistent fonts throughout a document
- Test readability from the back of a room (or at distance)

### ❌ Don't Do This

- Don't use script, handwritten, or decorative fonts
- Don't use serif fonts for body text (use only for special contexts if needed)
- Don't recreate the Agile Six logo with system fonts
- Don't use all caps for long passages (accessibility and readability issue)
- Don't use font sizes below 14pt (and 14pt must be bold)
- Don't use light font weights for small text
- Don't mix too many font families (stick to one or two max)
- Don't use excessive text in sections (use concise bullet points)

## Special Use Cases

### Headers and Footers

- **Font size**: 10-12pt (exempt from 508 minimums as they're not primary content)
- **Weight**: Regular (400)
- **Color**: Dark Grey (#707372)
- **Content**: Page numbers, dates, document titles

### Quotes / Callouts

- **Font size**: 24-36pt
- **Weight**: Bold (700) or Medium (500)
- **Color**: Navy (#003A70) or Light Blue on navy background
- **Style**: May use italic for emphasis
- **Usage**: Pull quotes, key statistics, important callouts

### Table Text

- **Header row**: 16-18pt, Bold (700), Navy (#003A70)
- **Body cells**: 14-16pt, Regular (400), Dark Grey (#707372)
- **Ensure**: All text meets contrast requirements
- **Alignment**: Left for text, right for numbers

## Font Pairing Examples

### Example 1: Montserrat Only
- **Headings**: Montserrat Bold
- **Body**: Montserrat Regular
- **Emphasis**: Montserrat SemiBold
- **Notes**: Clean, cohesive, single-font approach

### Example 2: Raleway + Montserrat
- **Headings**: Raleway Bold (elegant display)
- **Body**: Montserrat Regular (readability)
- **Result**: Sophisticated pairing with visual interest

### Example 3: Fallback (Calibri)
- **Headings**: Calibri Bold
- **Body**: Calibri Regular
- **Result**: Professional, universally available

## Typography in Context

### Formal Client Materials
- Use primary fonts (Montserrat or Raleway)
- Larger sizes for emphasis (48pt+ titles)
- More white space, less text per section
- Professional polish in all type treatments

### Internal Team Updates
- Can use fallback fonts (Calibri) for speed
- Standard sizes (32pt headers, 18pt body)
- More content allowed per section
- Prioritize clarity over design sophistication

### Data-Heavy Materials
- Smaller titles (28-32pt) to make room for content
- Consistent, readable body text (18pt)
- Clear chart labels (14-16pt bold)
- Organized hierarchy for scanability

## Font Selection Quick Reference

### Which Font Should I Use?

**For Print Materials**:
1. **Nexa** (preferred - if licensed)
2. **Arial** (official alternate)

**For Web/Digital**:
1. **Montserrat** (best Nexa alternative, free)
2. **Raleway** (elegant option, free)
3. **Gotham** (if licensed)

**For Digital/Office Documents**:
1. **Montserrat** (if installed)
2. **Arial** (official alternate, universally available)
3. **Calibri** (universal fallback)

**Decision Tree**:
```
Is this print material?
  → YES: Use Nexa (if available), else Arial
  → NO: Is this for web/screen?
       → YES: Use Montserrat (best) or Raleway
       → NO: Is this digital document?
            → YES: Use Arial (preferred) or Calibri
```

## Quick Typography Reference

```
FONTS (in order of preference):
  Print: Nexa → Arial
  Web/Digital: Montserrat → Raleway → Gotham
  Digital Documents: Arial → Montserrat → Calibri

TITLE SECTIONS:
  Title: 44pt Bold (Nexa Extra Bold / Montserrat Bold)
  Subtitle: 28pt Regular, Grey or Light Blue

CONTENT SECTIONS:
  Section Header: 32pt Bold (Nexa Bold / Montserrat Bold)
  Body Text: 18pt Regular (Nexa Regular / Arial Regular)
  Bullets: 18-20pt Regular, Dark Grey

CHARTS:
  Chart Title: 24-28pt Bold, Navy
  Axis Labels: 16-18pt Regular, Dark Grey
  Data Labels: 14-16pt Bold, Dark Grey

MINIMUM SIZES (508 Compliance):
  Body Text: 18pt minimum
  Small Text: 14pt minimum (must be bold)
  Headers: 24pt+ minimum

FONT WEIGHTS:
  Nexa: Book, Regular, Bold, Extra Bold (+ Italics)
  Arial: Regular, Bold, Black
  Montserrat: Regular (400), Bold (700), ExtraBold (800)
```

## Tagline Typography

When including the Agile Six tagline: **"A better place to work. Better work to do."**

- **Font**: Use body font (Nexa Regular, Arial Regular, Montserrat Regular, or Calibri)
- **Size**: 18-24pt depending on context
- **Weight**: Regular (400) or Medium (500)
- **Color**: Navy (#003A70) or White on dark backgrounds
- **Format**: Two sentences with period separator (NOT comma or dash)
- **Placement**: Near logo, at end of document, or as footer element
- **Correct Format**: "A better place to work. Better work to do." (two sentences)
- **Incorrect Formats**:
  - ❌ "A better place to work, better work to do." (comma incorrect)
  - ❌ "A better place to work - better work to do." (dash incorrect)

**Source**: [Copywriting Guidelines](copywriting-guidelines.md) for tagline punctuation rules

---

## See Also

- [Color Palette](colors.md) - Brand colors for text and backgrounds
- [Logo Usage](logo-usage.md) - Logo specifications and placement
- [Copywriting Guidelines](copywriting-guidelines.md) - Capitalization and style rules
- [Accessibility Standards](accessibility-standards.md) - WCAG 2.1 AA compliance
- [Print Specifications](print-specifications.md) - Print typography guidance

---

**Version**: 2.0 | **Last Updated**: November 17, 2025 | **Source**: AgileSix_styleguide_DRAFT5.pdf (February 2024 v.5), Page 10
