# Voice and Tone Examples

**Version**: 1.0
**Last Updated**: November 17, 2025
**Source**: Agent 2 Voice/Tone Analysis (extracted from AboutUs.pdf, Recruiting_Interview_Guide.pdf, capabilities materials)

## Overview

This document provides real-world examples of Agile Six's voice and tone across different material types. Use these patterns and examples to maintain brand consistency in your writing.

## Voice Characteristics by Material Type

### Recruiting and Marketing Materials

**Tone**: Warm, authentic, human-centered, inspiring

**Key Characteristics**:
- Aspirational and welcoming
- Values-driven language
- Inclusive vocabulary ("everyone," "authentic selves")
- Action-oriented verbs ("pursue," "build," "create")
- Personal and relatable

**Sentence Structure**:
- Mix of short punchy sentences (5-8 words)
- Longer descriptive sentences (20+ words) for detail
- Varied rhythm keeps content engaging

**Paragraph Length**: 2-4 sentences

**Emotional Register**: Aspirational, welcoming, empowering

**Source**: Agent 2 Voice/Tone Analysis, Recruiting Materials

### Client-Facing and Proposals

**Tone**: Professional, confident, partnership-oriented, outcome-focused

**Key Characteristics**:
- Government-fluent language
- Partnership framing ("shoulder-to-shoulder")
- Outcome-focused ("extraordinary outcomes")
- Competent and credible
- Collaborative approach

**Sentence Structure**:
- Longer, more complex sentences
- Information-dense
- Professional formality

**Paragraph Length**: 3-5 sentences

**Emotional Register**: Competent, credible, partnership-oriented

**Source**: Agent 2 Voice/Tone Analysis, Client-Facing Materials

### Internal and Process Documents

**Tone**: Direct, transparent, informative, supportive

**Key Characteristics**:
- Clear and directive
- Transparent communication
- Values-aware even in process docs
- Supportive and accommodating
- Action-oriented

**Sentence Structure**:
- Short, directive sentences
- Clear instructions
- Frequent breaks for readability

**Paragraph Length**: 2-3 sentences with frequent breaks

**Format**: Numbered lists, bold emphasis, clear sections

**Emotional Register**: Transparent, supportive, direct

**Source**: Agent 2 Voice/Tone Analysis, Internal Documents

## Employee Testimonial Examples

### Format

```
[EMPLOYEE NAME - ALL CAPS]
[Job Title - sentence case]
[Quote in first person, 2-4 sentences, personal and values-focused]
```

### Example 1: Software Engineer

**TANNER**
Software Engineer

"The self-management layer, coupled with trust, is our 'secret sauce.' It's fulfilling to work in a place that values me and contributes to the betterment of society."

**Analysis**:
- First-person ("I," "me")
- Personal emotional connection ("fulfilling," "values me")
- Connects to Agile Six values (self-management, trust)
- Mentions societal impact (purpose)
- Natural contractions ("It's")
- 25 words

**Source**: Agent 2 Voice/Tone Analysis, Recruiting_Interview_Guide.pdf

### Example 2: Pattern Analysis

**Common Elements in Employee Testimonials**:
- First-person perspective (authentic voice)
- Personal, conversational language
- Connect work to personal values or life balance
- Mention specific Agile Six values or practices
- 25-50 words typically
- Use contractions naturally ("we're," "it's," "I've")
- May note Veteran status when applicable

**Vocabulary Patterns**:
- "fulfilling," "authentic," "values," "trust," "purpose"
- "betterment," "society," "meaningful," "matters"
- Personal pronouns ("I," "me," "my")
- Values keywords (from core values)

**Sentence Structure**:
- Mix of statements and emotional responses
- Often 2-3 sentences total
- One sentence connects to values/culture
- One sentence explains personal impact

**Source**: Agent 2 Voice/Tone Analysis

## Recruiting Copy Patterns

### Pattern 1: Direct, Action-Oriented

**Example**:
> "We pursue work that matters."

**Characteristics**:
- 5 words (very concise)
- Action verb ("pursue")
- Meaningful work theme
- Direct, declarative
- Core value (Purpose)

**Use For**:
- Headlines
- Pull quotes
- CTAs
- Values statements

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Pattern 2: Inclusive, Welcoming

**Example**:
> "We hold space for people to be their complete and authentic selves."

**Characteristics**:
- Inclusive language ("people," not specific group)
- "Complete and authentic selves" (wholeness)
- Welcoming tone
- Longer sentence (12 words)
- Core value (Wholeness)

**Use For**:
- Culture descriptions
- DEI statements
- Values communications
- Recruiting pages

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Pattern 3: Descriptive, Comprehensive

**Example**:
> "Agile Six is a people-first, fully remote company that serves shoulder-to-shoulder with federal agencies to find innovative, human-centered solutions."

**Characteristics**:
- Comprehensive company description
- Multiple brand attributes in one sentence
- Hyphenated descriptors ("people-first," "human-centered")
- Partnership language ("shoulder-to-shoulder")
- 21 words
- Information-dense

**Use For**:
- Company descriptions
- About pages
- Recruiting materials
- General introductions

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Pattern 4: Audience-Inclusive

**Example**:
> "Using modern technology and design, we create user-friendly, accessible, and inclusive government services for everyone."

**Characteristics**:
- Ends with "for everyone" (inclusive)
- Three-part list ("user-friendly, accessible, and inclusive")
- Clear benefit statement
- 16 words
- Mission-focused

**Use For**:
- Service descriptions
- Mission statements
- Client communications
- Public-facing materials

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

## Client-Facing Copy Patterns

### Pattern 1: Partnership Description

**Example**:
> "Partnering with CMS to modernize complex Medicare payment systems, Agile Six is utilizing user research and human-centered design to reduce burden and improve outcomes."

**Characteristics**:
- Opens with "Partnering with [Agency]"
- Present progressive tense ("is utilizing")
- Government-fluent vocabulary
- Outcome-focused ("reduce burden and improve outcomes")
- Specific work mentioned
- 24 words
- Professional, formal tone

**Use For**:
- Proposals
- Capabilities statements
- Case studies
- Client materials

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Pattern 2: Support/In-Support-Of Description

**Example**:
> "In support of VA's Digital Modernization effort to create an exceptional user experience, Agile Six is implementing digital services that make it easier for Veterans and VA stakeholders to access the services and support they deserve."

**Characteristics**:
- Opens with "In support of [Agency's Initiative]"
- Agency's goal stated first
- Connects to end user benefit ("Veterans and VA stakeholders")
- Emphasizes deservedness ("deserve")
- 36 words
- Respectful, mission-aligned tone

**Use For**:
- VA-specific materials
- Mission-driven proposals
- Capabilities statements
- Client communications emphasizing alignment

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Pattern 3: Differentiation Statement

**Example**:
> "What sets Agile Six apart is our ability to create extraordinary outcomes through purpose-driven cross-disciplinary teams, healthy delivery ecosystems, and trust-based relationships with partners and stakeholders."

**Characteristics**:
- Opens with "What sets Agile Six apart"
- Three-part list structure
- Value-laden vocabulary ("purpose-driven," "trust-based")
- "Extraordinary outcomes" emphasis
- 27 words
- Confident but not boastful

**Use For**:
- Competitive differentiators
- Proposal "Why Us" sections
- Capabilities statements
- Marketing materials

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

## Internal Communication Patterns

### Pattern: Transparent, Direct

**Characteristics** (from process documents):
- Short sentences (5-10 words)
- Numbered lists for steps
- Bold emphasis on key points
- "We" language (inclusive)
- Clear expectations
- Direct imperatives ("Do this," "Remember to")

**Example Structure**:
```
1. **First step**: Clear instruction here.
2. **Second step**: Another clear action.
3. **Third step**: Final action or note.
```

**Use For**:
- Internal procedures
- Team updates
- Process documentation
- How-to guides

**Source**: Agent 2 Voice/Tone Analysis, Internal Documents

## Standard Phrase Library

### Company Character

| Phrase | Words | Use Context |
|--------|-------|-------------|
| "people-first, fully remote company" | 5 | Company descriptor |
| "serves shoulder-to-shoulder with federal agencies" | 6 | Partnership approach |
| "innovative, human-centered solutions" | 3 | Solution type |
| "user-friendly, accessible, and inclusive government services" | 6 | Service description |
| "for everyone" | 2 | Inclusive ending |
| "putting people first in everything we do" | 7 | Work approach |

### Outcomes and Impact

| Phrase | Words | Use Context |
|--------|-------|-------------|
| "create extraordinary outcomes" | 3 | Results focus |
| "purpose-driven cross-disciplinary teams" | 3 | Team structure |
| "healthy delivery ecosystems" | 3 | Delivery environment |
| "trust-based relationships with partners and stakeholders" | 7 | Partnership quality |

### Values Integration

| Phrase | Words | Value Connected |
|--------|-------|-----------------|
| "work that matters" | 3 | Purpose |
| "complete and authentic selves" | 4 | Wholeness |
| "based on trust" | 3 | Trust |
| "no managers here!" | 3 | Self-Management |
| "see, hear, and value people" | 5 | Inclusion |
| "our core values are our North Star" | 7 | Values introduction |

**Source**: Agent 2 Voice/Tone Analysis, Phrase Extraction

## Writing Patterns by Context

### Headlines and Pull Quotes

**Pattern**: Short (3-8 words), action-oriented, values-connected

**Examples**:
- "We pursue work that matters." (5 words)
- "Build a career with purpose." (5 words)
- "A better place to work." (5 words - from tagline)

**Source**: Agent 2 Voice/Tone Analysis

### Body Text (Recruiting)

**Pattern**: 2-4 sentences per paragraph, mix of short and long, personal tone

**Example Structure**:
```
[Short declarative sentence - 5-8 words.] [Longer descriptive sentence expanding on the idea - 15-25 words, including specific details and benefits.] [Medium concluding sentence connecting to values or action - 10-15 words.]
```

**Source**: Agent 2 Voice/Tone Analysis

### Body Text (Client-Facing)

**Pattern**: 3-5 sentences per paragraph, complex sentences, professional tone

**Example Structure**:
```
[Partnership context sentence - 20-30 words.] [Specific work description - 20-30 words.] [Outcome or impact statement - 15-25 words.] [Optional: Values or approach connection - 15-20 words.]
```

**Source**: Agent 2 Voice/Tone Analysis

## Vocabulary Guidelines

### Preferred Vocabulary

**Use These Words**:
- People-first: "people," "everyone," "individuals," "team members"
- Action verbs: "pursue," "build," "create," "serve," "implement," "deliver"
- Values words: "trust," "purpose," "wholeness," "authentic," "inclusive"
- Partnership: "shoulder-to-shoulder," "collaborate," "partner," "together"
- Outcomes: "extraordinary," "meaningful," "impact," "improve," "modernize"

**Source**: Agent 2 Voice/Tone Analysis, Vocabulary Patterns

### Avoid These Words

**Don't Use**:
- Vendor language: "vendor," "contractor" (use "partner")
- Customer language: "customer" for agencies (use "partner" or "client")
- Corporate jargon: "synergy," "leverage" (without specific meaning)
- Exclusionary: "guys," "manpower" (use "team," "everyone," "workforce")

**Source**: Agent 2 Voice/Tone Analysis; Inclusive language guidelines

## Contractions Usage

### When to Use Contractions

**Recruiting/Marketing**: YES - use naturally
- "We're driven by our values."
- "It's fulfilling to work here."
- "You'll find purpose in your work."

**Internal/Team**: YES - use naturally
- "We're updating the process."
- "Here's what you need to know."
- "It's important to remember..."

**Source**: Agent 2 Voice/Tone Analysis

### When to Avoid Contractions

**Formal Client-Facing**: Use sparingly or avoid
- "We are partnering with..." (not "We're partnering")
- "Agile Six is utilizing..." (not "Agile Six's utilizing")
- Okay in less formal contexts or quotes

**Source**: Agent 2 Voice/Tone Analysis

## Before/After Examples

### Example 1: Recruiting Copy

**Before** (Generic):
"We're hiring talented developers to work on government projects. Apply now."

**After** (Agile Six Voice):
"We pursue work that matters - serving shoulder-to-shoulder with federal agencies to create user-friendly, accessible, and inclusive government services for everyone. Build a career with purpose."

**What Changed**:
- Added core value ("pursue work that matters")
- Used standard partnership language ("shoulder-to-shoulder")
- Included mission statement language
- Connected to purpose (not just "apply now")
- Removed generic "talented" and "projects"

**Source**: Agent 2 Voice/Tone Analysis, Pattern Application

### Example 2: Client-Facing Copy

**Before** (Generic):
"Agile Six provides IT modernization services to federal agencies."

**After** (Agile Six Voice):
"Partnering with federal agencies to find innovative, human-centered solutions, Agile Six creates extraordinary outcomes through purpose-driven cross-disciplinary teams and trust-based relationships with partners and stakeholders."

**What Changed**:
- Changed "provides services" to "partnering" (collaboration vs transaction)
- Added values-driven language ("purpose-driven," "trust-based")
- Emphasized outcomes ("extraordinary outcomes")
- Used "human-centered" (mission focus)
- More specific about approach

**Source**: Agent 2 Voice/Tone Analysis, Pattern Application

## Additional Resources

For more guidance on voice and tone:
- [Copywriting Guidelines](../brand/copywriting-guidelines.md) - Capitalization and terminology
- [Boilerplate Text Library](../reference/boilerplate-text.md) - Exact approved phrases
- [Brand Essence](../brand/brand-essence.md) - Core values and brand story

---

**Version**: 1.0 | **Last Updated**: November 17, 2025 | **Source**: Agent 2 Voice/Tone Analysis (AboutUs.pdf, Recruiting_Interview_Guide.pdf, capabilities materials)
