# Boilerplate Text Library

**Version**: 1.0
**Last Updated**: November 17, 2025
**Source**: Agent 2 Voice/Tone Analysis (extracted from AboutUs.pdf, recruiting materials, interview guides)

## Overview

This library contains exact, approved text for use in Agile Six materials. Use these exact phrases to ensure brand consistency across all communications.

**Important**: Copy text exactly as shown, including punctuation and capitalization.

## Company Descriptions

### Primary Company Description (Recruiting/General Use)

> "Agile Six is a people-first, fully remote company that serves shoulder-to-shoulder with federal agencies to find innovative, human-centered solutions. Using modern technology and design, we create user-friendly, accessible, and inclusive government services for everyone."

**Character count**: 277 characters
**Word count**: 38 words

**Use for**:
- Recruiting materials
- General company descriptions
- Website "About" sections
- Marketing materials
- Social media bios (may need to shorten)

**Core elements** (must include):
- "people-first"
- "fully remote"
- "shoulder-to-shoulder with federal agencies"
- "innovative, human-centered solutions"
- "modern technology and design"
- "user-friendly, accessible, and inclusive government services"
- "for everyone"

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf extraction

### "How We Work" Description

> "We build better by putting people first in everything we do, from our company culture centered on wholeness and inclusion, to our human-centric, data-driven solutions reached in close collaboration with our clients."

**Use for**:
- Capabilities statements
- Proposals
- Client-facing materials explaining our approach

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Differentiation Statement

> "What sets Agile Six apart is our ability to create extraordinary outcomes through purpose-driven cross-disciplinary teams, healthy delivery ecosystems, and trust-based relationships with partners and stakeholders."

**Use for**:
- Proposals
- Capabilities statements
- Competitive differentiators
- "Why Agile Six" sections

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Values-Driven Statement

> "We are driven by our core values of Purpose, Wholeness, Trust, Self-Management, and Inclusion."

**Use for**:
- Company descriptions that emphasize culture
- Recruiting materials
- Values-focused communications
- Following detailed descriptions of work

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

## Tagline

### Official Tagline (EXACT PUNCTUATION)

> "A better place to work. Better work to do."

**CRITICAL**: Two sentences with period separator

**Correct Format**: "A better place to work. Better work to do."

**Incorrect Formats**:
- ❌ "A better place to work, better work to do." (comma)
- ❌ "A better place to work - better work to do." (dash)
- ❌ "A better place to work: better work to do." (colon)

**Use for**:
- Logo with tagline
- Closing sections
- Marketing materials
- Social media
- Email signatures

**Source**: Agent 2 Voice/Tone Analysis; AgileSix_styleguide_DRAFT5.pdf

## Core Values (EXACT WORDING)

### Values Introduction

**Header**: "At Agile Six, our core values are our North Star."

**Use**: Always use this exact introduction when presenting all five values together

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### The Five Core Values

#### 1. PURPOSE

**Statement**: "We pursue work that matters."

**Expanded description** (when more detail needed):
"We pursue work that matters - serving shoulder-to-shoulder with federal agencies to find innovative, human-centered solutions that improve lives."

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

#### 2. WHOLENESS

**Statement**: "We hold space for people to be their complete and authentic selves."

**Expanded description**:
"We hold space for people to be their complete and authentic selves. We believe everyone should be able to bring their full, authentic self to work."

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

#### 3. TRUST

**Statement**: "We build relationships based on trust—among teammates, customers, and partners."

**Note**: Use em dash (—) as shown, not hyphen

**Expanded description**:
"We build relationships based on trust—among teammates, customers, and partners. Trust is the foundation of our self-managed organization and our client partnerships."

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

#### 4. SELF-MANAGEMENT

**Statement**: "We reinforce autonomy (no managers here!) and local decision-making in individuals and teams."

**Note**: Include "(no managers here!)" exactly as shown - it's a key differentiator

**Expanded description**:
"We reinforce autonomy (no managers here!) and local decision-making in individuals and teams. Everyone has the authority and responsibility to make decisions in their domain."

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

#### 5. INCLUSION

**Statement**: "We see, hear, and value people."

**Expanded description**:
"We see, hear, and value people. Inclusion means actively creating space for diverse perspectives and ensuring everyone's voice matters."

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

## Agency Partnership Descriptions

### Template Format

```
[In support of / Partnering with] [AGENCY NAME] [to achieve goal],
Agile Six [is/was verb-ing] [specific work] [that results in outcome].
```

### Department of Veterans Affairs (VA)

> "In support of VA's Digital Modernization effort to create an exceptional user experience, Agile Six is implementing digital services that make it easier for Veterans and VA stakeholders to access the services and support they deserve."

**Use for**: VA-focused materials, case studies, capabilities statements

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Centers for Medicare & Medicaid Services (CMS)

> "Partnering with CMS to modernize complex Medicare payment systems, Agile Six is utilizing user research and human-centered design to reduce burden and improve outcomes."

**Use for**: CMS-focused materials, healthcare capability statements

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### Centers for Disease Control and Prevention (CDC)

> "In support of CDC's Pandemic Readiness and Data Modernization Initiative to modernize core data and surveillance infrastructure, Agile Six is creating integrated, real-time solutions across federal, state, and local health landscapes."

**Use for**: CDC-focused materials, public health capability statements

**Source**: Agent 2 Voice/Tone Analysis, AboutUs.pdf

### General Federal Agency (Template)

> "Partnering with [AGENCY NAME] to [agency goal/initiative], Agile Six is [specific work approach] to [desired outcome]."

**Customize** with:
- Specific agency name and acronym
- Agency's stated mission or initiative
- Agile Six's specific role and methods
- Measurable or meaningful outcomes

**Source**: Pattern extracted from Agent 2 analysis

## Capability Descriptions

### User-Centered Design

> "Using modern technology and design, we create user-friendly, accessible, and inclusive government services."

**Use for**: UX/UI capability descriptions

**Source**: Agent 2 Voice/Tone Analysis

### Human-Centered Solutions

> "Innovative, human-centered solutions that put people first."

**Use for**: General capability statements, service descriptions

**Source**: Agent 2 Voice/Tone Analysis

### Digital Modernization

> "Implementing digital services that create an exceptional user experience."

**Use for**: Modernization projects, digital transformation proposals

**Source**: Agent 2 Voice/Tone Analysis

### Delivery Approach

> "Purpose-driven cross-disciplinary teams, healthy delivery ecosystems, and trust-based relationships with partners and stakeholders."

**Use for**: Describing our delivery methodology, agile approach

**Source**: Agent 2 Voice/Tone Analysis

## Standard Phrases Quick Reference

### Company Character

| Context | Exact Phrase | Length |
|---------|-------------|--------|
| Company type | "people-first, fully remote company" | 5 words |
| Partnership style | "serves shoulder-to-shoulder with federal agencies" | 6 words |
| Solution focus | "innovative, human-centered solutions" | 3 words |
| Service quality | "user-friendly, accessible, and inclusive government services" | 6 words |
| Audience | "for everyone" | 2 words |
| Culture foundation | "putting people first in everything we do" | 7 words |

### Outcomes and Impact

| Context | Exact Phrase | Length |
|---------|-------------|--------|
| Differentiation | "create extraordinary outcomes" | 3 words |
| Team structure | "purpose-driven cross-disciplinary teams" | 3 words |
| Delivery environment | "healthy delivery ecosystems" | 3 words |
| Partnership quality | "trust-based relationships with partners and stakeholders" | 7 words |

### Values Keywords

| Value | Key Phrase | Length |
|-------|-----------|--------|
| Introduction | "our core values are our North Star" | 7 words |
| Purpose | "work that matters" | 3 words |
| Wholeness | "complete and authentic selves" | 4 words |
| Trust | "based on trust" | 3 words |
| Self-Management | "no managers here!" | 3 words |
| Inclusion | "see, hear, and value people" | 5 words |

**Source**: Agent 2 Voice/Tone Analysis

## Call-to-Action Examples

### Recruiting CTAs

- "Build a career with purpose."
- "Join our team of Sixers."
- "Explore life at Agile Six."
- "See open positions."
- "Get an inside look at life at Agile Six." (for Sixer Spotlight content)

**Source**: Agent 2 Voice/Tone Analysis, Recruiting Materials

### Client Engagement CTAs

- "Let's partner on your next challenge."
- "Explore how we can help."
- "Learn more about our approach."
- "Connect with our team."

**Source**: Agent 2 Voice/Tone Analysis

## Employee Testimonial Format

### Structure

```
[EMPLOYEE NAME - ALL CAPS]
[Job Title - sentence case]
[Quote in first person, 2-4 sentences, personal and values-focused]
```

### Example

**TANNER**
Software Engineer
"The self-management layer, coupled with trust, is our 'secret sauce.' It's fulfilling to work in a place that values me and contributes to the betterment of society."

**Source**: Agent 2 Voice/Tone Analysis, Recruiting_Interview_Guide.pdf

### Pattern Requirements

When creating employee testimonials:
- First-person perspective
- Personal, conversational language
- Connect work to personal values or life
- Mention specific Agile Six values or practices
- 25-50 words typically
- Use contractions naturally ("we're," "it's")
- Note Veteran status when applicable and relevant

**Source**: Agent 2 Voice/Tone Analysis

## Usage Guidelines

### When to Use Exact Text

**MUST use exact text**:
- Tagline (punctuation critical)
- Core values statements
- Company description (recruiting)
- Official boilerplate for press releases

### When to Adapt

**May adapt with caution**:
- Agency partnership descriptions (customize for specific agency)
- Capability descriptions (tailor to proposal requirements)
- Employee testimonials (authentic to individual)

### When to Create Original

**Create original copy** (following guidelines):
- Specific project descriptions
- Technical explanations
- Individual employee quotes
- Context-specific marketing

**But maintain**:
- Voice and tone patterns
- Standard terminology
- Brand values alignment
- Capitalization rules

## Revision and Updates

**Official boilerplate text should not be modified** without coordination with brand/marketing team.

**For questions about**:
- New boilerplate needs
- Adapting existing text
- Agency-specific variations
- Updated company descriptions

**Consult**: Brand/marketing team or use patterns from this library

---

## See Also

- [Copywriting Guidelines](../brand/copywriting-guidelines.md) - Capitalization and style rules
- [Brand Essence](../brand/brand-essence.md) - Core values and brand story
- [Voice and Tone Examples](../examples/voice-tone-examples.md) - Real-world usage examples
- [Typography Guidelines](../brand/typography.md) - Tagline formatting

---

**Version**: 1.0 | **Last Updated**: November 17, 2025 | **Source**: Agent 2 Voice/Tone Analysis
